/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class CharPattern
extends ObjectPattern<Character, CharPattern> {
    protected CharPattern() {
        super(Character.class);
    }

    public CharPattern javaIdentifierPart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierPart"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                if (character == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/CharPattern$1", "accepts"));
                }
                return Character.isJavaIdentifierPart(character.charValue());
            }
        });
    }

    public CharPattern javaIdentifierStart() {
        return (CharPattern)this.with(new PatternCondition<Character>("javaIdentifierStart"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                if (character == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/CharPattern$2", "accepts"));
                }
                return Character.isJavaIdentifierStart(character.charValue());
            }
        });
    }

    public CharPattern whitespace() {
        return (CharPattern)this.with(new PatternCondition<Character>("whitespace"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                if (character == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/CharPattern$3", "accepts"));
                }
                return Character.isWhitespace(character.charValue());
            }
        });
    }

    public CharPattern letterOrDigit() {
        return (CharPattern)this.with(new PatternCondition<Character>("letterOrDigit"){

            @Override
            public boolean accepts(@NotNull Character character, ProcessingContext context) {
                if (character == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/patterns/CharPattern$4", "accepts"));
                }
                return Character.isLetterOrDigit(character.charValue());
            }
        });
    }
}

