/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.elements.RenameablePackagingElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompositePackagingElement<S>
extends PackagingElement<S>
implements RenameablePackagingElement {
    private final List<PackagingElement<?>> myChildren = new ArrayList();
    private List<PackagingElement<?>> myUnmodifiableChildren;

    protected CompositePackagingElement(PackagingElementType type) {
        super(type);
    }

    public <T extends PackagingElement<?>> T addOrFindChild(@NotNull T child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "addOrFindChild"));
        }
        for (PackagingElement<?> element : this.myChildren) {
            if (!element.isEqualTo(child)) continue;
            if (element instanceof CompositePackagingElement) {
                List<PackagingElement<?>> children = ((CompositePackagingElement)child).getChildren();
                ((CompositePackagingElement)element).addOrFindChildren(children);
            }
            return (T)element;
        }
        this.myChildren.add(child);
        return child;
    }

    public void addFirstChild(@NotNull PackagingElement<?> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "addFirstChild"));
        }
        this.myChildren.add(0, child);
        for (int i = 1; i < this.myChildren.size(); ++i) {
            PackagingElement<?> element = this.myChildren.get(i);
            if (!element.isEqualTo(child)) continue;
            if (element instanceof CompositePackagingElement) {
                ((CompositePackagingElement)child).addOrFindChildren(((CompositePackagingElement)element).getChildren());
            }
            this.myChildren.remove(i);
            break;
        }
    }

    public List<? extends PackagingElement<?>> addOrFindChildren(Collection<? extends PackagingElement<?>> children) {
        ArrayList added = new ArrayList();
        for (PackagingElement<?> child : children) {
            added.add(this.addOrFindChild(child));
        }
        return added;
    }

    @Nullable
    public PackagingElement<?> moveChild(int index, int direction) {
        int target = index + direction;
        if (0 <= index && index < this.myChildren.size() && 0 <= target && target < this.myChildren.size()) {
            PackagingElement<?> element1 = this.myChildren.get(index);
            PackagingElement<?> element2 = this.myChildren.get(target);
            this.myChildren.set(index, element2);
            this.myChildren.set(target, element1);
            return element1;
        }
        return null;
    }

    public void removeChild(@NotNull PackagingElement<?> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "removeChild"));
        }
        this.myChildren.remove(child);
    }

    public void removeChildren(@NotNull Collection<? extends PackagingElement<?>> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "removeChildren"));
        }
        this.myChildren.removeAll(children);
    }

    @NotNull
    public List<PackagingElement<?>> getChildren() {
        if (this.myUnmodifiableChildren == null) {
            this.myUnmodifiableChildren = Collections.unmodifiableList(this.myChildren);
        }
        List<PackagingElement<?>> list = this.myUnmodifiableChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/elements/CompositePackagingElement", "getChildren"));
        }
        return list;
    }

    @Override
    public boolean canBeRenamed() {
        return true;
    }

    protected List<? extends Generator> computeChildrenGenerators(PackagingElementResolvingContext resolvingContext, AntCopyInstructionCreator copyInstructionCreator, ArtifactAntGenerationContext generationContext, ArtifactType artifactType) {
        ArrayList<Generator> generators = new ArrayList<Generator>();
        for (PackagingElement<?> child : this.myChildren) {
            generators.addAll(child.computeAntInstructions(resolvingContext, copyInstructionCreator, generationContext, artifactType));
        }
        return generators;
    }

    protected void computeChildrenInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "computeChildrenInstructions"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/elements/CompositePackagingElement", "computeChildrenInstructions"));
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/elements/CompositePackagingElement", "computeChildrenInstructions"));
        }
        for (PackagingElement<?> child : this.myChildren) {
            child.computeIncrementalCompilerInstructions(creator, resolvingContext, compilerContext, artifactType);
        }
    }

    public void removeAllChildren() {
        this.myChildren.clear();
    }

    @Nullable
    public CompositePackagingElement<?> findCompositeChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/CompositePackagingElement", "findCompositeChild"));
        }
        for (PackagingElement<?> child : this.myChildren) {
            if (!(child instanceof CompositePackagingElement) || !name.equals(((CompositePackagingElement)child).getName())) continue;
            return (CompositePackagingElement)child;
        }
        return null;
    }
}

