/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.elements;

import com.intellij.compiler.ant.Generator;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.ArtifactIncrementalCompilerContext;
import com.intellij.packaging.elements.IncrementalCompilerInstructionCreator;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComplexPackagingElement<S>
extends PackagingElement<S> {
    protected ComplexPackagingElement(PackagingElementType type) {
        super(type);
    }

    @Override
    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/ComplexPackagingElement", "computeAntInstructions"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/elements/ComplexPackagingElement", "computeAntInstructions"));
        }
        if (generationContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/elements/ComplexPackagingElement", "computeAntInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/elements/ComplexPackagingElement", "computeAntInstructions"));
        }
        List<PackagingElement<?>> substitution = this.getSubstitution(resolvingContext, artifactType);
        if (substitution == null) {
            return Collections.emptyList();
        }
        ArrayList<Generator> fileSets = new ArrayList<Generator>();
        for (PackagingElement<?> element : substitution) {
            fileSets.addAll(element.computeAntInstructions(resolvingContext, creator, generationContext, artifactType));
        }
        return fileSets;
    }

    @Override
    public void computeIncrementalCompilerInstructions(@NotNull IncrementalCompilerInstructionCreator creator, @NotNull PackagingElementResolvingContext resolvingContext, @NotNull ArtifactIncrementalCompilerContext compilerContext, @NotNull ArtifactType artifactType) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/packaging/elements/ComplexPackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (resolvingContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/packaging/elements/ComplexPackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (compilerContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/packaging/elements/ComplexPackagingElement", "computeIncrementalCompilerInstructions"));
        }
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/packaging/elements/ComplexPackagingElement", "computeIncrementalCompilerInstructions"));
        }
        List<PackagingElement<?>> substitution = this.getSubstitution(resolvingContext, artifactType);
        if (substitution == null) {
            return;
        }
        for (PackagingElement<?> element : substitution) {
            element.computeIncrementalCompilerInstructions(creator, resolvingContext, compilerContext, this.getArtifactTypeForSubstitutedElements(resolvingContext, artifactType));
        }
    }

    protected ArtifactType getArtifactTypeForSubstitutedElements(PackagingElementResolvingContext resolvingContext, ArtifactType artifactType) {
        return artifactType;
    }

    @Nullable
    public abstract List<? extends PackagingElement<?>> getSubstitution(@NotNull PackagingElementResolvingContext var1, @NotNull ArtifactType var2);
}

