/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughIdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFocusManager
implements FocusRequestor {
    @Nullable
    public abstract JComponent getFocusTargetFor(@NotNull JComponent var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1);

    public abstract void doWhenFocusSettlesDown(@NotNull ExpirableRunnable var1);

    @Nullable
    public abstract Component getFocusedDescendantFor(Component var1);

    public abstract boolean dispatch(@NotNull KeyEvent var1);

    public abstract void typeAheadUntil(ActionCallback var1);

    public abstract boolean isFocusBeingTransferred();

    @NotNull
    public abstract ActionCallback requestDefaultFocus(boolean var1);

    public abstract boolean isFocusTransferEnabled();

    @NotNull
    public abstract Expirable getTimestamp(boolean var1);

    @NotNull
    public abstract FocusRequestor getFurtherRequestor();

    public abstract void revalidateFocus(@NotNull ExpirableRunnable var1);

    public abstract void setTypeaheadEnabled(boolean var1);

    public abstract Component getFocusOwner();

    public abstract void runOnOwnContext(@NotNull DataContext var1, @NotNull Runnable var2);

    @Nullable
    public abstract Component getLastFocusedFor(@Nullable IdeFrame var1);

    @Nullable
    public abstract IdeFrame getLastFocusedFrame();

    public abstract void toFront(JComponent var1);

    public static IdeFocusManager getInstance(@Nullable Project project) {
        if (project == null) {
            return IdeFocusManager.getGlobalInstance();
        }
        if (project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return project.getComponent(IdeFocusManager.class);
    }

    @NotNull
    public static IdeFocusManager findInstanceByContext(@Nullable DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe(CommonDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        IdeFocusManager ideFocusManager = instance;
        if (ideFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/IdeFocusManager", "findInstanceByContext"));
        }
        return ideFocusManager;
    }

    @NotNull
    public static IdeFocusManager findInstanceByComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/wm/IdeFocusManager", "findInstanceByComponent"));
        }
        IdeFocusManager instance = IdeFocusManager.findByComponent(c);
        IdeFocusManager ideFocusManager = instance != null ? instance : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/IdeFocusManager", "findInstanceByComponent"));
        }
        return ideFocusManager;
    }

    @Nullable
    private static IdeFocusManager findByComponent(Component c) {
        Component parent = UIUtil.findUltimateParent((Component)c);
        if (parent instanceof IdeFrame) {
            return IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject());
        }
        return null;
    }

    @Nullable
    private static IdeFocusManager getInstanceSafe(@Nullable Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    @NotNull
    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        IdeFocusManager ideFocusManager = owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
        if (ideFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/IdeFocusManager", "findInstance"));
        }
        return ideFocusManager;
    }

    @NotNull
    public static IdeFocusManager getGlobalInstance() {
        IdeFocusManager fm = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.hasComponent(IdeFocusManager.class)) {
            fm = app.getComponent(IdeFocusManager.class);
        }
        if (fm == null) {
            fm = PassThroughIdeFocusManager.getInstance();
        }
        PassThroughIdeFocusManager passThroughIdeFocusManager = fm;
        if (passThroughIdeFocusManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/IdeFocusManager", "getGlobalInstance"));
        }
        return passThroughIdeFocusManager;
    }
}

