/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.KeyEventProcessor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FocusCommand
extends ActiveRunnable
implements Expirable {
    protected Component myDominationComponent;
    private Throwable myAllocation;
    private ActionCallback myCallback;
    private boolean myInvalidatesPendingFurtherRequestors = true;
    private Expirable myExpirable;
    private boolean myForced;

    public boolean isForced() {
        return this.myForced;
    }

    public void setForced(boolean forced) {
        this.myForced = forced;
    }

    protected FocusCommand() {
        this.saveAllocation();
    }

    protected FocusCommand(Component dominationComp) {
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    protected FocusCommand(Object object) {
        super(object);
        this.saveAllocation();
    }

    protected FocusCommand(Object object, Component dominationComp) {
        super(object);
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    protected FocusCommand(Object[] objects) {
        super(objects);
        this.saveAllocation();
    }

    protected FocusCommand(Object[] objects, Component dominationComp) {
        super(objects);
        this.myDominationComponent = dominationComp;
        this.saveAllocation();
    }

    public final ActionCallback getCallback() {
        return this.myCallback;
    }

    public final void setCallback(ActionCallback callback) {
        this.myCallback = callback;
    }

    @Override
    public boolean isExpired() {
        return this.myExpirable != null && this.myExpirable.isExpired();
    }

    public boolean canExecuteOnInactiveApp() {
        return false;
    }

    @Nullable
    public KeyEventProcessor getProcessor() {
        return null;
    }

    public boolean invalidatesRequestors() {
        return this.myInvalidatesPendingFurtherRequestors;
    }

    public FocusCommand setExpirable(Expirable expirable) {
        this.myExpirable = expirable;
        return this;
    }

    public FocusCommand setToInvalidateRequestors(boolean invalidatesPendingFurtherRequestors) {
        this.myInvalidatesPendingFurtherRequestors = invalidatesPendingFurtherRequestors;
        return this;
    }

    @Nullable
    public final Component getDominationComponent() {
        return this.myDominationComponent;
    }

    public boolean dominatesOver(FocusCommand cmd) {
        Component thisComponent = PopupUtil.getOwner(this.getDominationComponent());
        Component thatComponent = PopupUtil.getOwner(cmd.getDominationComponent());
        if (thisComponent != null && thatComponent != null) {
            return thisComponent != thatComponent && SwingUtilities.isDescendingFrom(thisComponent, thatComponent);
        }
        return false;
    }

    public final FocusCommand saveAllocation() {
        this.myAllocation = new Exception();
        return this;
    }

    public Throwable getAllocation() {
        return this.myAllocation;
    }

    public String toString() {
        Object[] objects = this.getEqualityObjects();
        return "FocusCommand objectCount=" + objects.length + " objects=" + Arrays.asList(objects);
    }

    public static class ByComponent
    extends FocusCommand {
        private Component myToFocus;

        public ByComponent(@Nullable Component toFocus) {
            this(toFocus, toFocus);
        }

        public ByComponent(@Nullable Component toFocus, @Nullable Component dominationComponent) {
            super(toFocus, dominationComponent);
            this.myToFocus = toFocus;
        }

        @Override
        @NotNull
        public final ActionCallback run() {
            if (this.myToFocus != null) {
                if (Registry.is((String)"actionSystem.doNotStealFocus")) {
                    Window topWindow = SwingUtilities.windowForComponent(this.myToFocus);
                    UIUtil.setAutoRequestFocus((Window)topWindow, (boolean)topWindow.isActive());
                    while (topWindow.getOwner() != null) {
                        topWindow = SwingUtilities.windowForComponent(topWindow);
                        UIUtil.setAutoRequestFocus((Window)topWindow, (boolean)topWindow.isActive());
                    }
                    if (topWindow.isActive()) {
                        if (!this.myToFocus.requestFocusInWindow()) {
                            this.myToFocus.requestFocus();
                        }
                    } else {
                        this.myToFocus.requestFocusInWindow();
                    }
                } else if (!(this.myToFocus.requestFocusInWindow() || SystemInfo.isMac && !this.isForced())) {
                    this.myToFocus.requestFocus();
                }
            }
            this.clear();
            ActionCallback.Done done = new ActionCallback.Done();
            if (done == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/FocusCommand$ByComponent", "run"));
            }
            return done;
        }

        private void clear() {
            this.myToFocus = null;
            this.myDominationComponent = null;
        }

        @Override
        public boolean isExpired() {
            if (this.myToFocus == null) {
                return true;
            }
            if (SwingUtilities.getWindowAncestor(this.myToFocus) == null) {
                this.clear();
                return true;
            }
            return false;
        }

        public Component getComponent() {
            return this.myToFocus;
        }
    }
}

