/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, @NotNull VirtualFile file, VirtualFile newParent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "<init>"));
        }
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myOldParent = file.getParent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFile"));
        }
        return virtualFile;
    }

    public VirtualFile getNewParent() {
        return this.myNewParent;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    public String getPath() {
        return this.myFile.getPath();
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && Comparing.equal((Object)this.myFile.getParent(), (Object)this.myOldParent) && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myOldParent.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        return result;
    }
}

