/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

public class VirtualFileFilteringListener
implements VirtualFileListener {
    private final VirtualFileListener myDelegate;
    private final VirtualFileSystem myFilter;

    public VirtualFileFilteringListener(@NotNull VirtualFileListener delegate, @NotNull VirtualFileSystem filter) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "<init>"));
        }
        this.myDelegate = delegate;
        this.myFilter = filter;
    }

    private boolean isGood(VirtualFileEvent event) {
        return event.getFile().getFileSystem() == this.myFilter;
    }

    @Override
    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "beforeContentsChange"));
        }
        if (this.isGood(event)) {
            this.myDelegate.beforeContentsChange(event);
        }
    }

    @Override
    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "beforeFileDeletion"));
        }
        if (this.isGood(event)) {
            this.myDelegate.beforeFileDeletion(event);
        }
    }

    @Override
    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "beforeFileMovement"));
        }
        if (this.isGood(event)) {
            this.myDelegate.beforeFileMovement(event);
        }
    }

    @Override
    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "beforePropertyChange"));
        }
        if (this.isGood(event)) {
            this.myDelegate.beforePropertyChange(event);
        }
    }

    @Override
    public void contentsChanged(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "contentsChanged"));
        }
        if (this.isGood(event)) {
            this.myDelegate.contentsChanged(event);
        }
    }

    @Override
    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "fileCopied"));
        }
        if (this.isGood(event)) {
            this.myDelegate.fileCopied(event);
        }
    }

    @Override
    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "fileCreated"));
        }
        if (this.isGood(event)) {
            this.myDelegate.fileCreated(event);
        }
    }

    @Override
    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "fileDeleted"));
        }
        if (this.isGood(event)) {
            this.myDelegate.fileDeleted(event);
        }
    }

    @Override
    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "fileMoved"));
        }
        if (this.isGood(event)) {
            this.myDelegate.fileMoved(event);
        }
    }

    @Override
    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/newvfs/VirtualFileFilteringListener", "propertyChanged"));
        }
        if (this.isGood(event)) {
            this.myDelegate.propertyChanged(event);
        }
    }
}

