/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecatedVirtualFileSystem
extends VirtualFileSystem {
    private final EventDispatcher<VirtualFileListener> myEventDispatcher = EventDispatcher.create(VirtualFileListener.class);

    protected void startEventPropagation() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return;
        }
        application.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this.myEventDispatcher.getMulticaster(), this));
    }

    @Override
    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "addVirtualFileListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "removeVirtualFileListener"));
        }
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    protected void firePropertyChanged(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "firePropertyChanged"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "firePropertyChanged"));
        }
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).propertyChanged(event);
    }

    protected void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireContentsChanged"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getParent(), oldModificationStamp, file.getModificationStamp());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).contentsChanged(event);
    }

    protected void fireFileCreated(@Nullable Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileCreated"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCreated(event);
    }

    protected void fireFileDeleted(Object requestor, @NotNull VirtualFile file, @NotNull String fileName, VirtualFile parent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileDeleted"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileDeleted"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, fileName, parent);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileDeleted(event);
    }

    protected void fireFileMoved(Object requestor, @NotNull VirtualFile file, VirtualFile oldParent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileMoved"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, oldParent, file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileMoved(event);
    }

    protected void fireFileCopied(@Nullable Object requestor, @NotNull VirtualFile originalFile, @NotNull VirtualFile createdFile) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileCopied"));
        }
        if (createdFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireFileCopied"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileCopyEvent event = new VirtualFileCopyEvent(requestor, originalFile, createdFile);
        try {
            ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCopied(event);
        }
        catch (AbstractMethodError e) {
            ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).fileCreated(event);
        }
    }

    protected void fireBeforePropertyChange(Object requestor, @NotNull VirtualFile file, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireBeforePropertyChange"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireBeforePropertyChange"));
        }
        this.assertWriteAccessAllowed();
        VirtualFilePropertyEvent event = new VirtualFilePropertyEvent(requestor, file, propertyName, oldValue, newValue);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforePropertyChange(event);
    }

    protected void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireBeforeContentsChange"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeContentsChange(event);
    }

    protected void fireBeforeFileDeletion(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireBeforeFileDeletion"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileEvent event = new VirtualFileEvent(requestor, file, file.getName(), file.getParent());
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeFileDeletion(event);
    }

    protected void fireBeforeFileMovement(Object requestor, @NotNull VirtualFile file, VirtualFile newParent) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/DeprecatedVirtualFileSystem", "fireBeforeFileMovement"));
        }
        this.assertWriteAccessAllowed();
        VirtualFileMoveEvent event = new VirtualFileMoveEvent(requestor, file, file.getParent(), newParent);
        ((VirtualFileListener)this.myEventDispatcher.getMulticaster()).beforeFileMovement(event);
    }

    protected void assertWriteAccessAllowed() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

