/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalChangeList
implements Cloneable,
ChangeList {
    @NonNls
    public static final String DEFAULT_NAME = VcsBundle.message("changes.default.changelist.name", new Object[0]);

    public static LocalChangeList createEmptyChangeList(Project project, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vcs/changes/LocalChangeList", "createEmptyChangeList"));
        }
        return VcsContextFactory.SERVICE.getInstance().createLocalChangeList(project, name);
    }

    @Override
    public abstract Collection<Change> getChanges();

    @NotNull
    public String getId() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/LocalChangeList", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public abstract String getName();

    public abstract void setName(@NotNull String var1);

    @Override
    @Nullable
    public abstract String getComment();

    public abstract void setComment(@Nullable String var1);

    public abstract boolean isDefault();

    public abstract boolean isReadOnly();

    public abstract void setReadOnly(boolean var1);

    @Nullable
    public abstract Object getData();

    public abstract LocalChangeList copy();

    public boolean hasDefaultName() {
        return DEFAULT_NAME.equals(this.getName());
    }
}

