/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CompoundNumber;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ReadonlyList;
import com.intellij.util.containers.StepList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ReadonlyListsMerger<T> {
    private final List<ReadonlyList<T>> myLists;
    private final Consumer<CompoundNumber> myConsumer;
    private final Comparator<Pair<CompoundNumber, T>> myComparator;

    private ReadonlyListsMerger(List<ReadonlyList<T>> lists, Consumer<CompoundNumber> consumer, Comparator<Pair<CompoundNumber, T>> comparator) {
        this.myLists = lists;
        this.myConsumer = consumer;
        this.myComparator = comparator;
    }

    public static <T extends Comparable<T>> void merge(List<ReadonlyList<T>> lists, Consumer<CompoundNumber> consumer) {
        new ReadonlyListsMerger<T>(lists, consumer, new MyComparator()).execute();
    }

    public static <T> void merge(List<ReadonlyList<T>> lists, Consumer<CompoundNumber> consumer, Comparator<Pair<CompoundNumber, T>> comparator) {
        new ReadonlyListsMerger<T>(lists, consumer, comparator).execute();
    }

    public void execute() {
        int[] idxs = new int[this.myLists.size()];
        for (int i = 0; i < this.myLists.size(); ++i) {
            ReadonlyList<T> member = this.myLists.get(i);
            idxs[i] = member.getSize() == 0 ? -1 : 0;
        }
        while (true) {
            CompoundNumber minIdxs = null;
            for (int i = 0; i < idxs.length; ++i) {
                if (idxs[i] == -1) continue;
                ReadonlyList<T> list = this.myLists.get(i);
                if (minIdxs != null && this.myComparator.compare(new Pair((Object)new CompoundNumber(i, idxs[i]), list.get(idxs[i])), new Pair((Object)minIdxs, this.myLists.get(minIdxs.getMemberNumber()).get(minIdxs.getIdx()))) > 0) continue;
                minIdxs = new CompoundNumber(i, idxs[i]);
            }
            if (minIdxs == null) {
                return;
            }
            this.myConsumer.consume(minIdxs);
            int memberIdx = minIdxs.getMemberNumber();
            idxs[memberIdx] = this.myLists.get(memberIdx).getSize() == idxs[memberIdx] + 1 ? -1 : idxs[memberIdx] + 1;
        }
    }

    public static <T> void firstPlusSecond(final StepList<T> first, ReadonlyList<T> second, Comparator<T> comparator, final @Nullable Consumer<T> beforeAddListener, Processor<T> filter) {
        if (second.getSize() == 0) {
            return;
        }
        int idx = ReadonlyListsMerger.stolenBinarySearch(first, second.get(0), comparator, 0);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        if (idx > 0 && !filter.process(first.get(idx - 1)) && --idx > 0) {
            --idx;
        }
        ReadonlyList remergePart = first.cut(idx);
        ReadonlyListsMerger.merge(remergePart, second, comparator, new Consumer<T>(){

            public void consume(T t) {
                if (beforeAddListener != null) {
                    beforeAddListener.consume(t);
                }
                first.add(t);
            }
        }, filter);
    }

    public static <T> void merge(ReadonlyList<T> one, ReadonlyList<T> two, Comparator<T> comparator, Consumer<T> adder, Processor<T> filter) {
        Object firstOne;
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < one.getSize() && idx2 < two.getSize()) {
            firstOne = one.get(idx1);
            if (!filter.process(firstOne)) {
                ++idx1;
                continue;
            }
            int comp = comparator.compare(firstOne, two.get(idx2));
            if (comp <= 0) {
                adder.consume(firstOne);
                ++idx1;
                continue;
            }
            adder.consume(two.get(idx2));
            ++idx2;
        }
        while (idx1 < one.getSize()) {
            firstOne = one.get(idx1);
            if (!filter.process(firstOne)) {
                ++idx1;
                continue;
            }
            adder.consume(one.get(idx1));
            ++idx1;
        }
        while (idx2 < two.getSize()) {
            adder.consume(two.get(idx2));
            ++idx2;
        }
    }

    private static <T> int stolenBinarySearch(ReadonlyList<? extends T> l, T key, Comparator<? super T> c, int from) {
        int low = from;
        int high = l.getSize() - from - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Object midVal = l.get(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static class MyComparator<T extends Comparable<T>>
    implements Comparator<Pair<CompoundNumber, T>> {
        private MyComparator() {
        }

        @Override
        public int compare(Pair<CompoundNumber, T> o1, Pair<CompoundNumber, T> o2) {
            return ((Comparable)o1.getSecond()).compareTo(o2.getSecond());
        }
    }
}

