/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AreaMap;
import com.intellij.openapi.vcs.ComparableComparator;
import com.intellij.util.PairProcessor;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;

public class MembershipMap<Key, Val>
extends AreaMap<Key, Val> {
    public static <Key extends Comparable<Key>, Val> MembershipMap<Key, Val> createMembershipMap(PairProcessor<Key, Key> keysResemblance) {
        return new MembershipMap<Key, Val>(keysResemblance, new ComparableComparator());
    }

    public static <Key, Val> MembershipMap<Key, Val> createMembershipMap(PairProcessor<Key, Key> keysResemblance, Comparator<Key> comparator) {
        return new MembershipMap<Key, Val>(keysResemblance, comparator);
    }

    private MembershipMap(PairProcessor<Key, Key> keysResemblance, Comparator<Key> comparator) {
        super(keysResemblance, comparator);
    }

    public void putOptimal(Key key, Val val) {
        int idx = this.putIfNoParent(key, val);
        if (idx < 0) {
            return;
        }
        if (idx + 1 < this.myKeys.size()) {
            Object next;
            ListIterator listIterator = this.myKeys.listIterator(idx + 1);
            while (listIterator.hasNext() && this.myKeysResemblance.process(key, next = listIterator.next())) {
                listIterator.remove();
                this.myMap.remove(next);
            }
        }
    }

    public void optimizeMap(PairProcessor<Val, Val> valuesAreas) {
        int i = 0;
        Iterator iterator = this.myKeys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = this.myMap.get(key);
            for (int j = i - 1; j >= 0; --j) {
                Object innerKey = this.myKeys.get(j);
                if (!this.myKeysResemblance.process(innerKey, key)) continue;
                if (!valuesAreas.process(this.myMap.get(innerKey), value)) break;
                --i;
                iterator.remove();
                this.myMap.remove(key);
                break;
            }
            ++i;
        }
    }

    public Pair<Key, Val> getMapping(Key key) {
        final Ref result = new Ref();
        this.getSimiliar(key, new PairProcessor<Key, Val>(){

            public boolean process(Key key, Val val) {
                result.set((Object)new Pair(key, val));
                return true;
            }
        });
        return (Pair)result.get();
    }
}

