/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.text.DateFormatUtil;
import java.util.Comparator;
import java.util.Date;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeListColumn<T extends ChangeList> {
    public static ChangeListColumn<CommittedChangeList> DATE = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.date", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate());
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return o1.getCommitDate().compareTo(o2.getCommitDate());
                }
            };
        }
    };
    public static ChangeListColumn<CommittedChangeList> NAME = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.committer", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getCommitterName();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return Comparing.compare((Comparable)((Object)((String)this.getValue(o1))), (Comparable)((Object)((String)this.getValue(o2))));
                }
            };
        }
    };
    public static ChangeListColumn<CommittedChangeList> NUMBER = new ChangeListNumberColumn(VcsBundle.message("column.name.revision.list.number", new Object[0]));
    public static ChangeListColumn<CommittedChangeList> DESCRIPTION = new ChangeListColumn<CommittedChangeList>(){

        @Override
        public String getTitle() {
            return VcsBundle.message("column.name.revision.list.description", new Object[0]);
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getName();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
        }
    };

    public abstract String getTitle();

    public abstract Object getValue(T var1);

    @Nullable
    public Comparator<T> getComparator() {
        return null;
    }

    public static boolean isCustom(ChangeListColumn column) {
        return column != DATE && column != DESCRIPTION && column != NAME && !(column instanceof ChangeListNumberColumn);
    }

    public static class ChangeListNumberColumn
    extends ChangeListColumn<CommittedChangeList> {
        private final String myTitle;

        public ChangeListNumberColumn(String title) {
            this.myTitle = title;
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public Object getValue(CommittedChangeList changeList) {
            return changeList.getNumber();
        }

        @Override
        public Comparator<CommittedChangeList> getComparator() {
            return new Comparator<CommittedChangeList>(){

                @Override
                public int compare(CommittedChangeList o1, CommittedChangeList o2) {
                    return (int)(o1.getNumber() - o2.getNumber());
                }
            };
        }
    }
}

