/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.TextComponentUndoProvider;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithBrowseButton
extends ComponentWithBrowseButton<JTextField>
implements TextAccessor {
    public TextFieldWithBrowseButton() {
        this((ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field) {
        this(field, (ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field, @Nullable ActionListener browseActionListener) {
        super(field, browseActionListener);
        if (ApplicationManager.getApplication() != null) {
            this.installPathCompletion(FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            new TextComponentUndoProvider(this.getTextField());
        }
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener) {
        this(new JTextField(10), browseActionListener);
    }

    public void addBrowseFolderListener(@Nullable String title, @Nullable String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor) {
        this.addBrowseFolderListener(title, description, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.installPathCompletion(fileChooserDescriptor);
    }

    public void addBrowseFolderListener(@NotNull TextBrowseFolderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/TextFieldWithBrowseButton", "addBrowseFolderListener"));
        }
        listener.setOwnerComponent(this);
        this.addBrowseFolderListener(null, listener, true);
        this.installPathCompletion(listener.gFileChooserDescriptor());
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
        this.installPathCompletion(fileChooserDescriptor, null);
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        FileChooserFactory.getInstance().installFileCompletion((JTextField)this.getChildComponent(), fileChooserDescriptor, true, parent);
    }

    public JTextField getTextField() {
        return (JTextField)this.getChildComponent();
    }

    @Override
    public String getText() {
        return this.getTextField().getText();
    }

    @Override
    public void setText(String text) {
        this.getTextField().setText(text);
    }

    public boolean isEditable() {
        return this.getTextField().isEditable();
    }

    public void setEditable(boolean b) {
        this.getTextField().setEditable(b);
        this.getButton().setFocusable(!b);
        this.getTextField().setFocusable(b);
    }

    public static class NoPathCompletion
    extends TextFieldWithBrowseButton {
        public NoPathCompletion() {
        }

        public NoPathCompletion(JTextField field) {
            super(field);
        }

        public NoPathCompletion(JTextField field, ActionListener browseActionListener) {
            super(field, browseActionListener);
        }

        public NoPathCompletion(ActionListener browseActionListener) {
            super(browseActionListener);
        }

        @Override
        protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
        }
    }
}

