/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Queryable {
    public void putInfo(@NotNull Map<String, String> var1);

    public static interface Contributor {
        public void apply(@NotNull Map<String, String> var1);
    }

    public static class Util {
        @Nullable
        public static String print(@NotNull Queryable ui, @Nullable PrintInfo printInfo, @Nullable Contributor contributor) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/Queryable$Util", "print"));
            }
            PrintInfo print = printInfo != null ? printInfo : new PrintInfo();
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            ui.putInfo(map);
            if (contributor != null) {
                contributor.apply(map);
            }
            String id = null;
            if (!map.isEmpty()) {
                id = map.values().iterator().next();
            }
            StringBuilder info = new StringBuilder();
            if (print.myInfoKeys != null) {
                for (String eachKey : print.myInfoKeys) {
                    String eachValue = map.get(eachKey);
                    if (eachValue == null) continue;
                    if (info.length() > 0) {
                        info.append(",");
                    }
                    info.append(eachKey).append("=").append(eachValue);
                }
            }
            return id + (info.length() > 0 ? " " + info.toString() : "");
        }

        @Nullable
        public static String print(@NotNull Queryable ui, @Nullable PrintInfo printInfo) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/Queryable$Util", "print"));
            }
            return Util.print(ui, printInfo, null);
        }
    }

    public static class PrintInfo {
        private final String[] myIdKeys;
        private final String[] myInfoKeys;

        public PrintInfo() {
            this(null, null);
        }

        public PrintInfo(@Nullable String[] idKeys) {
            this(idKeys, null);
        }

        public PrintInfo(@Nullable String[] idKeys, @Nullable String[] infoKeys) {
            this.myIdKeys = idKeys;
            this.myInfoKeys = infoKeys;
        }
    }
}

