/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.notification.NotificationType;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MessageType {
    public static final MessageType ERROR = new MessageType(UIUtil.getBalloonErrorIcon(), (Color)new JBColor(new Color(255, 204, 204, 230), new Color(112, 71, 69)));
    public static final MessageType INFO = new MessageType(UIUtil.getBalloonInformationIcon(), (Color)new JBColor(new Color(186, 238, 186, 230), new Color(73, 117, 73)));
    public static final MessageType WARNING = new MessageType(UIUtil.getBalloonWarningIcon(), (Color)new JBColor(new Color(249, 247, 142, 230), new Color(90, 82, 33)));
    private final Icon myDefaultIcon;
    private final Color myPopupBackground;

    private MessageType(@NotNull Icon defaultIcon, @NotNull Color popupBackground) {
        if (defaultIcon == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/MessageType", "<init>"));
        }
        if (popupBackground == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/ui/MessageType", "<init>"));
        }
        this.myDefaultIcon = defaultIcon;
        this.myPopupBackground = popupBackground;
    }

    @NotNull
    public Icon getDefaultIcon() {
        Icon icon = this.myDefaultIcon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "getDefaultIcon"));
        }
        return icon;
    }

    @NotNull
    public Color getPopupBackground() {
        Color color = this.myPopupBackground;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "getPopupBackground"));
        }
        return color;
    }

    @NotNull
    public NotificationType toNotificationType() {
        NotificationType notificationType = this == ERROR ? NotificationType.ERROR : (this == WARNING ? NotificationType.WARNING : NotificationType.INFORMATION);
        if (notificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MessageType", "toNotificationType"));
        }
        return notificationType;
    }
}

