/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBox
extends ComboBoxWithWidePopup
implements AWTEventListener {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    private int myMinimumAndPreferredWidth;
    private boolean mySwingPopup;
    private JBPopup myJBPopup;
    protected boolean myPaintingNow;

    public ComboBox() {
        this(-1);
    }

    public ComboBox(ComboBoxModel model) {
        this(model, -1);
    }

    public ComboBox(int width) {
        this(new DefaultComboBoxModel(), width);
    }

    public ComboBox(ComboBoxModel model, int width) {
        super(model);
        this.mySwingPopup = true;
        this.myMinimumAndPreferredWidth = width;
        this.registerCancelOnEscape();
        UIUtil.installComboBoxCopyAction((JComboBox)this);
        JButton arrowButton = (JButton)UIUtil.findComponentOfType((JComponent)this, JButton.class);
        if (arrowButton != null) {
            arrowButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!ComboBox.this.mySwingPopup) {
                        e.consume();
                        ComboBox.this.setPopupVisible(true);
                    }
                }
            });
        }
    }

    public static void registerTableCellEditor(@NotNull JComboBox comboBox, @NotNull TableCellEditor cellEditor) {
        if (comboBox == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/ComboBox", "registerTableCellEditor"));
        }
        if (cellEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/ui/ComboBox", "registerTableCellEditor"));
        }
        comboBox.putClientProperty(TABLE_CELL_EDITOR_PROPERTY, cellEditor);
        comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
    }

    public void registerTableCellEditor(@NotNull TableCellEditor cellEditor) {
        if (cellEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/ComboBox", "registerTableCellEditor"));
        }
        ComboBox.registerTableCellEditor(this, cellEditor);
    }

    @Override
    public void setPopupVisible(boolean visible) {
        if (!this.isSwingPopup()) {
            if (visible && (this.myJBPopup == null || this.myJBPopup.isDisposed())) {
                final JBList list = this.createJBList(this.getModel());
                this.myJBPopup = JBPopupFactory.getInstance().createListPopupBuilder(list).setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        Object value = list.getSelectedValue();
                        if (value != null) {
                            ComboBox.this.configureEditor(ComboBox.this.getEditor(), value);
                            IdeFocusManager.getGlobalInstance().requestFocus(ComboBox.this, true);
                            assert (ComboBox.this.myJBPopup != null);
                            ComboBox.this.getUI().setPopupVisible(ComboBox.this, false);
                            ComboBox.this.myJBPopup.cancel();
                        }
                    }
                }).setFocusOwners(new Component[]{this}).setMinSize(new Dimension(this.getWidth(), -1)).createPopup();
                list.setBorder(IdeBorderFactory.createEmptyBorder());
                this.myJBPopup.showUnderneathOf(this);
                list.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ComboBox.this.getUI().setPopupVisible(ComboBox.this, false);
                        ComboBox.this.myJBPopup.cancel();
                    }
                });
            }
            return;
        }
        if (this.getModel().getSize() == 0 && visible) {
            return;
        }
        if (visible && JBPopupFactory.getInstance().getChildFocusedPopup(this) != null) {
            return;
        }
        boolean wasShown = this.isPopupVisible();
        super.setPopupVisible(visible);
        if (!wasShown && visible && this.isEditable() && !UIManager.getBoolean("ComboBox.isEnterSelectablePopup")) {
            ComboBoxEditor editor = this.getEditor();
            Object item = editor.getItem();
            Object selectedItem = this.getSelectedItem();
            if (this.isSwingPopup() && (item == null || item != selectedItem)) {
                this.configureEditor(editor, selectedItem);
            }
        }
    }

    protected JBList createJBList(ComboBoxModel model) {
        return new JBList((ListModel)model);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 200) {
            WindowEvent we = (WindowEvent)event;
            List<JBPopup> popups = JBPopupFactory.getInstance().getChildPopups(this);
            if (popups != null) {
                for (JBPopup each : popups) {
                    if (each.getContent() == null || !SwingUtilities.isDescendingFrom(each.getContent(), we.getWindow())) continue;
                    super.setPopupVisible(false);
                }
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (SwingUtilities.getAncestorOfClass(JTable.class, this) != null) {
            this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.myJBPopup != null) {
            this.getUI().setPopupVisible(this, false);
            this.myJBPopup.cancel();
        }
    }

    @Nullable
    public ComboPopup getPopup() {
        return UIUtil.getComboBoxPopup((JComboBox)this);
    }

    public ComboBox(Object[] items, int preferredWidth) {
        super(items);
        this.mySwingPopup = true;
        this.myMinimumAndPreferredWidth = preferredWidth;
        this.registerCancelOnEscape();
    }

    public ComboBox(@NotNull Object[] items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/ui/ComboBox", "<init>"));
        }
        this(items, -1);
    }

    public boolean isSwingPopup() {
        return this.mySwingPopup;
    }

    public void setSwingPopup(boolean swingPopup) {
        this.mySwingPopup = swingPopup;
    }

    public void setMinimumAndPreferredWidth(int minimumAndPreferredWidth) {
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
    }

    private void registerCancelOnEscape() {
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogWrapper dialogWrapper = DialogWrapper.findInstance(ComboBox.this);
                if (ComboBox.this.isPopupVisible()) {
                    ComboBox.this.setPopupVisible(false);
                } else {
                    Object clientProperty = ComboBox.this.getClientProperty(ComboBox.TABLE_CELL_EDITOR_PROPERTY);
                    if (clientProperty instanceof CellEditor) {
                        ((CellEditor)clientProperty).cancelCellEditing();
                    } else if (dialogWrapper != null) {
                        dialogWrapper.doCancelAction();
                    }
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    @Override
    public final void setEditor(ComboBoxEditor editor) {
        ComboBoxEditor _editor = editor;
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel() && "AquaComboBoxEditor".equals(editor.getClass().getSimpleName())) {
            _editor = new FixedComboBoxEditor();
        }
        super.setEditor(new MyEditor(this, _editor));
    }

    @Override
    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public final Dimension getPreferredSize() {
        int width = this.myMinimumAndPreferredWidth;
        Dimension preferredSize = super.getPreferredSize();
        if (width < 0) {
            width = preferredSize.width;
        }
        return new Dimension(width, UIUtil.fixComboBoxHeight((int)preferredSize.height));
    }

    @Override
    public boolean hasFocus() {
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel() && this.myPaintingNow) {
            return false;
        }
        return super.hasFocus();
    }

    @Override
    protected Dimension getOriginalPreferredSize() {
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        try {
            this.myPaintingNow = true;
            super.paint(g);
            if (Boolean.TRUE != this.getClientProperty("JComboBox.isTableCellEditor")) {
                MacUIUtil.drawComboboxFocusRing((JComboBox)this, (Graphics)g);
            }
        }
        finally {
            this.myPaintingNow = false;
        }
    }

    private static final class MyEditor
    implements ComboBoxEditor {
        private final JComboBox myComboBox;
        private final ComboBoxEditor myDelegate;

        public MyEditor(JComboBox comboBox, ComboBoxEditor delegate) {
            this.myComboBox = comboBox;
            this.myDelegate = delegate;
            if (this.myDelegate != null) {
                this.myDelegate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MyEditor.this.myComboBox.isPopupVisible()) {
                            MyEditor.this.myComboBox.setPopupVisible(false);
                        } else {
                            Object clientProperty = MyEditor.this.myComboBox.getClientProperty(ComboBox.TABLE_CELL_EDITOR_PROPERTY);
                            if (clientProperty instanceof CellEditor) {
                                ((CellEditor)clientProperty).stopCellEditing();
                            } else {
                                JButton button;
                                MyEditor.this.myComboBox.setSelectedItem(MyEditor.this.getItem());
                                JRootPane rootPane = MyEditor.this.myComboBox.getRootPane();
                                if (rootPane != null && (button = rootPane.getDefaultButton()) != null) {
                                    button.doClick();
                                }
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            if (this.myDelegate != null) {
                return this.myDelegate.getEditorComponent();
            }
            return null;
        }

        @Override
        public Object getItem() {
            if (this.myDelegate != null) {
                return this.myDelegate.getItem();
            }
            return null;
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
            if (this.myDelegate != null) {
                this.myDelegate.selectAll();
            }
        }

        @Override
        public void setItem(Object obj) {
            if (this.myDelegate != null) {
                this.myDelegate.setItem(obj);
            }
        }
    }
}

