/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultModulesProvider
implements ModulesProvider {
    private final Project myProject;

    @NotNull
    public static ModulesProvider createForProject(@Nullable Project project) {
        ModulesProvider modulesProvider = project == null ? EMPTY_MODULES_PROVIDER : new DefaultModulesProvider(project);
        if (modulesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider", "createForProject"));
        }
        return modulesProvider;
    }

    public DefaultModulesProvider(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ModuleManager.getInstance(this.myProject).getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider", "getModules"));
        }
        return moduleArray;
    }

    @Override
    public Module getModule(String name) {
        return ModuleManager.getInstance(this.myProject).findModuleByName(name);
    }

    @Override
    public ModuleRootModel getRootModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider", "getRootModel"));
        }
        return ModuleRootManager.getInstance(module);
    }

    @Override
    public FacetModel getFacetModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/ui/configuration/DefaultModulesProvider", "getFacetModel"));
        }
        return FacetManager.getInstance(module);
    }
}

