/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.roots.PersistentOrderRootType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class OrderRootType {
    private final String myName;
    private static boolean ourExtensionsLoaded = false;
    public static final ExtensionPointName<OrderRootType> EP_NAME = ExtensionPointName.create((String)"com.intellij.orderRootType");
    protected static PersistentOrderRootType[] ourPersistentOrderRootTypes = new PersistentOrderRootType[0];
    public static final OrderRootType CLASSES = new PersistentOrderRootType("CLASSES", "classPath", null, "classPathEntry");
    public static final OrderRootType SOURCES = new PersistentOrderRootType("SOURCES", "sourcePath", null, "sourcePathEntry");
    public static final OrderRootType DOCUMENTATION = new DocumentationRootType();

    protected OrderRootType(@NonNls String name) {
        this.myName = name;
    }

    public String name() {
        return this.myName;
    }

    public boolean skipWriteIfEmpty() {
        return false;
    }

    public static synchronized OrderRootType[] getAllTypes() {
        return OrderRootType.getAllPersistentTypes();
    }

    public static PersistentOrderRootType[] getAllPersistentTypes() {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            Extensions.getExtensions(EP_NAME);
        }
        return ourPersistentOrderRootTypes;
    }

    public static List<PersistentOrderRootType> getSortedRootTypes() {
        ArrayList<PersistentOrderRootType> allTypes = new ArrayList<PersistentOrderRootType>();
        Collections.addAll(allTypes, OrderRootType.getAllPersistentTypes());
        Collections.sort(allTypes, new Comparator<PersistentOrderRootType>(){

            @Override
            public int compare(PersistentOrderRootType o1, PersistentOrderRootType o2) {
                return o1.getSdkRootName().compareTo(o2.getSdkRootName());
            }
        });
        return allTypes;
    }

    protected static <T> T getOrderRootType(Class<? extends T> orderRootTypeClass) {
        OrderRootType[] rootTypes;
        for (OrderRootType rootType : rootTypes = (OrderRootType[])Extensions.getExtensions(EP_NAME)) {
            if (!orderRootTypeClass.isInstance(rootType)) continue;
            return (T)rootType;
        }
        assert (false) : "Root type " + orderRootTypeClass + " not found. All roots: " + Arrays.asList(rootTypes);
        return null;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Root " + this.name();
    }

    public static class DocumentationRootType
    extends OrderRootType {
        public DocumentationRootType() {
            super("DOCUMENTATION");
        }

        @Override
        public boolean skipWriteIfEmpty() {
            return true;
        }

        public String getSdkRootName() {
            return "documentation";
        }
    }
}

