/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.projectRoots.JavaSdkVersion;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JdkVersionUtil {
    private static final Map<JavaSdkVersion, String[]> VERSION_STRINGS = new EnumMap<JavaSdkVersion, String[]>(JavaSdkVersion.class);

    public static JavaSdkVersion getVersion(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/projectRoots/JdkVersionUtil", "getVersion"));
        }
        for (Map.Entry<JavaSdkVersion, String[]> entry : VERSION_STRINGS.entrySet()) {
            for (String s : entry.getValue()) {
                if (!versionString.contains(s)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    static {
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_0, new String[]{"1.0"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_1, new String[]{"1.1"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_2, new String[]{"1.2"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_3, new String[]{"1.3"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_4, new String[]{"1.4"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_5, new String[]{"1.5", "5.0"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_6, new String[]{"1.6", "6.0"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_7, new String[]{"1.7", "7.0"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_8, new String[]{"1.8", "8.0"});
        VERSION_STRINGS.put(JavaSdkVersion.JDK_1_9, new String[]{"1.9", "9.0"});
    }
}

