/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumbService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbService");
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic("dumb mode", DumbModeListener.class);
    private static final NotNullLazyKey<DumbService, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DumbService.class);

    public abstract boolean isDumb();

    public static boolean isDumb(Project project) {
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void runWhenSmart(Runnable var1);

    public abstract void waitForSmartMode();

    public <T> T runReadActionInSmartMode(final Computable<T> r) {
        final Ref result = new Ref();
        this.runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                result.set(r.compute());
            }
        });
        return (T)result.get();
    }

    @Nullable
    public <T> T tryRunReadActionInSmartMode(@NotNull Computable<T> task, @NotNull String notification) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "tryRunReadActionInSmartMode"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/DumbService", "tryRunReadActionInSmartMode"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            try {
                return (T)task.compute();
            }
            catch (IndexNotReadyException e) {
                this.showDumbModeNotification(notification);
                return null;
            }
        }
        return this.runReadActionInSmartMode(task);
    }

    public void runReadActionInSmartMode(final Runnable r) {
        boolean success;
        do {
            this.waitForSmartMode();
        } while (!(success = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            public Boolean compute() {
                if (DumbService.this.isDumb()) {
                    return false;
                }
                r.run();
                return true;
            }
        }).booleanValue()));
    }

    public void repeatUntilPassesInSmartMode(Runnable r) {
        while (true) {
            this.waitForSmartMode();
            try {
                r.run();
                return;
            }
            catch (IndexNotReadyException e) {
                LOG.info((Throwable)e);
                continue;
            }
            break;
        }
    }

    public void smartInvokeLater(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "smartInvokeLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        });
    }

    public void smartInvokeLater(final @NotNull Runnable runnable, ModalityState modalityState) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "smartInvokeLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DumbService.this.runWhenSmart(runnable);
            }
        }, modalityState);
    }

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "getInstance"));
        }
        return (DumbService)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        if (this.isDumb()) {
            ArrayList<T> result = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result.add(element);
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
            }
            return arrayList;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
            }
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/DumbService", "filterByDumbAwareness"));
        }
        return arrayList;
    }

    public abstract JComponent wrapGently(@NotNull JComponent var1, @NotNull Disposable var2);

    public void makeDumbAware(final @NotNull JComponent component, @NotNull Disposable disposable) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/DumbService", "makeDumbAware"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/DumbService", "makeDumbAware"));
        }
        component.setEnabled(!this.isDumb());
        this.getProject().getMessageBus().connect(disposable).subscribe(DUMB_MODE, (Object)new DumbModeListener(){

            @Override
            public void enteredDumbMode() {
                component.setEnabled(false);
            }

            @Override
            public void exitDumbMode() {
                component.setEnabled(true);
            }
        });
    }

    public abstract void showDumbModeNotification(String var1);

    public abstract Project getProject();

    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public static interface DumbModeListener {
        public void enteredDumbMode();

        public void exitDumbMode();
    }
}

