/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager {
    private static final ProgressManager ourInstance = ServiceManager.getService(ProgressManager.class);
    protected static volatile boolean ourNeedToCheckCancel;
    protected static final ThreadLocal<ProgressIndicator> myThreadIndicator;

    public static ProgressManager getInstance() {
        return ourInstance;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(@NotNull Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    public abstract <T> T runProcess(@NotNull Computable<T> var1, ProgressIndicator var2) throws ProcessCanceledException;

    public ProgressIndicator getProgressIndicator() {
        return myThreadIndicator.get();
    }

    public static void checkCanceled() throws ProcessCanceledException {
        if (ourNeedToCheckCancel) {
            ProgressManager.getInstance().doCheckCanceled();
            ourNeedToCheckCancel = false;
        }
    }

    public static void progress(String text) throws ProcessCanceledException {
        ProgressManager.progress(text, "");
    }

    public static void progress2(@NotNull String text) throws ProcessCanceledException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/ProgressManager", "progress2"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText2(text);
        }
    }

    public static void progress(String text, @Nullable String text2) throws ProcessCanceledException {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText(text);
            pi.setText2(text2 == null ? "" : text2);
        }
    }

    protected abstract void doCheckCanceled() throws ProcessCanceledException;

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract NonCancelableSection startNonCancelableSection();

    public abstract void setCancelButtonText(String var1);

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls String var2, boolean var3, @Nullable Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(@NotNull ThrowableComputable<T, E> var1, @NotNull @Nls String var2, boolean var3, @Nullable Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls String var2, boolean var3, @Nullable Project var4, @Nullable JComponent var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable var1, @NotNull ProgressIndicator var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        boolean set;
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/ProgressManager", "executeProcessUnderProgress"));
        }
        ProgressIndicator oldIndicator = null;
        boolean bl = set = progress != null && progress != (oldIndicator = myThreadIndicator.get());
        if (set) {
            myThreadIndicator.set(progress);
        }
        try {
            process.run();
        }
        finally {
            if (set) {
                myThreadIndicator.set(oldIndicator);
            }
        }
    }

    static {
        ProgressIndicatorProvider.ourInstance = new ProgressIndicatorProvider(){

            @Override
            public ProgressIndicator getProgressIndicator() {
                return ourInstance.getProgressIndicator();
            }

            @Override
            protected void doCheckCanceled() throws ProcessCanceledException {
                ourInstance.doCheckCanceled();
            }

            @Override
            public NonCancelableSection startNonCancelableSection() {
                return ourInstance.startNonCancelableSection();
            }
        };
        ourNeedToCheckCancel = false;
        myThreadIndicator = new ThreadLocal();
    }
}

