/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterLanguageFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SyntaxHighlighterFactory {
    public static final SyntaxHighlighterLanguageFactory LANGUAGE_FACTORY = new SyntaxHighlighterLanguageFactory();

    public static SyntaxHighlighter getSyntaxHighlighter(@NotNull Language language, @Nullable Project project, @Nullable VirtualFile file) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/SyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return ((SyntaxHighlighterFactory)LANGUAGE_FACTORY.forLanguage(language)).getSyntaxHighlighter(project, file);
    }

    @Nullable
    public static SyntaxHighlighter getSyntaxHighlighter(@NotNull FileType fileType, @Nullable Project project, @Nullable VirtualFile file) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/SyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return SyntaxHighlighter.PROVIDER.create(fileType, project, file);
    }

    @NotNull
    public abstract SyntaxHighlighter getSyntaxHighlighter(@Nullable Project var1, @Nullable VirtualFile var2);
}

