/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExactFileNameMatcher
implements FileNameMatcher {
    private final String myFileName;
    private final boolean myIgnoreCase;

    public ExactFileNameMatcher(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/ExactFileNameMatcher", "<init>"));
        }
        this.myFileName = fileName;
        this.myIgnoreCase = false;
    }

    public ExactFileNameMatcher(@NotNull @NonNls String fileName, boolean ignoreCase) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/ExactFileNameMatcher", "<init>"));
        }
        this.myFileName = fileName;
        this.myIgnoreCase = ignoreCase;
    }

    @Override
    public boolean accept(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileTypes/ExactFileNameMatcher", "accept"));
        }
        return Comparing.equal((String)fileName, (String)this.myFileName, (!this.myIgnoreCase ? 1 : 0) != 0);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/ExactFileNameMatcher", "getPresentableString"));
        }
        return string;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public boolean isIgnoreCase() {
        return this.myIgnoreCase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExactFileNameMatcher that = (ExactFileNameMatcher)o;
        return this.myFileName.equals(that.myFileName);
    }

    public int hashCode() {
        return this.myFileName.hashCode();
    }

    public String toString() {
        return this.getPresentableString();
    }
}

