/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import org.jetbrains.annotations.NotNull;

public class TextEditorLocation
implements FileEditorLocation {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.TextEditorLocation");
    private final TextEditor myEditor;
    private final LogicalPosition myPosition;

    public TextEditorLocation(int offset, @NotNull TextEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/TextEditorLocation", "<init>"));
        }
        this(editor.getEditor().offsetToLogicalPosition(offset), editor);
    }

    public TextEditorLocation(@NotNull LogicalPosition position, @NotNull TextEditor editor) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/TextEditorLocation", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/fileEditor/TextEditorLocation", "<init>"));
        }
        this.myEditor = editor;
        this.myPosition = position;
    }

    @Override
    @NotNull
    public FileEditor getEditor() {
        TextEditor textEditor = this.myEditor;
        if (textEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/TextEditorLocation", "getEditor"));
        }
        return textEditor;
    }

    @NotNull
    public LogicalPosition getPosition() {
        LogicalPosition logicalPosition = this.myPosition;
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/TextEditorLocation", "getPosition"));
        }
        return logicalPosition;
    }

    @Override
    public int compareTo(FileEditorLocation fileEditorLocation) {
        TextEditorLocation otherLocation = (TextEditorLocation)fileEditorLocation;
        if (this.myEditor != otherLocation.myEditor) {
            LOG.error("Different editors: " + this.myEditor + "; and " + otherLocation.myEditor);
        }
        return this.myPosition.compareTo(otherLocation.myPosition);
    }

    public String toString() {
        return this.myPosition.toString();
    }
}

