/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileChooserFactory {
    public static FileChooserFactory getInstance() {
        return ServiceManager.getService(FileChooserFactory.class);
    }

    @NotNull
    public abstract FileChooserDialog createFileChooser(@NotNull FileChooserDescriptor var1, @Nullable Project var2, @Nullable Component var3);

    @NotNull
    public abstract PathChooserDialog createPathChooser(@NotNull FileChooserDescriptor var1, @Nullable Project var2, @Nullable Component var3);

    @NotNull
    public abstract FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor var1, @Nullable Project var2);

    @NotNull
    public abstract FileSaverDialog createSaveFileDialog(@NotNull FileSaverDescriptor var1, @NotNull Component var2);

    @NotNull
    public abstract FileTextField createFileTextField(@NotNull FileChooserDescriptor var1, boolean var2, @Nullable Disposable var3);

    @NotNull
    public FileTextField createFileTextField(@NotNull FileChooserDescriptor descriptor, @Nullable Disposable parent) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserFactory", "createFileTextField"));
        }
        FileTextField fileTextField = this.createFileTextField(descriptor, true, parent);
        if (fileTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/FileChooserFactory", "createFileTextField"));
        }
        return fileTextField;
    }

    public abstract void installFileCompletion(@NotNull JTextField var1, @NotNull FileChooserDescriptor var2, boolean var3, @Nullable Disposable var4);
}

