/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileChooserDescriptorBuilder {
    private boolean myChooseFiles;
    private boolean myChooseFolders;
    private boolean myChooseJars;
    private boolean myChooseJarsAsFiles;
    private boolean myChooseJarContents;
    private boolean myChooseMultiple;
    private String myTitle = null;
    private String myDescription = null;
    private Boolean myShowFileSystemRoots = null;
    private Boolean myHideIgnored = null;
    private Boolean myTreeRootVisible = null;
    private List<VirtualFile> myRoots = null;

    public FileChooserDescriptorBuilder(boolean chooseFiles, boolean chooseFolders, boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents, boolean chooseMultiple) {
        this.myChooseFiles = chooseFiles;
        this.myChooseFolders = chooseFolders;
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        this.myChooseMultiple = chooseMultiple;
    }

    public static FileChooserDescriptorBuilder onlyFiles() {
        return new FileChooserDescriptorBuilder(true, false, false, false, false, false);
    }

    public static FileChooserDescriptorBuilder onlyFolders() {
        return new FileChooserDescriptorBuilder(false, true, false, false, false, false);
    }

    public static FileChooserDescriptorBuilder filesAndFolders() {
        return new FileChooserDescriptorBuilder(true, true, false, false, false, false);
    }

    public FileChooserDescriptorBuilder chooseMultiple() {
        this.myChooseMultiple = true;
        return this;
    }

    public FileChooserDescriptorBuilder chooseJars(boolean chooseJars, boolean chooseJarsAsFiles, boolean chooseJarContents) {
        this.myChooseJars = chooseJars;
        this.myChooseJarsAsFiles = chooseJarsAsFiles;
        this.myChooseJarContents = chooseJarContents;
        return this;
    }

    public FileChooserDescriptorBuilder withTitle(@NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserDescriptorBuilder", "withTitle"));
        }
        this.myTitle = title;
        return this;
    }

    public FileChooserDescriptorBuilder withDescription(@NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/FileChooserDescriptorBuilder", "withDescription"));
        }
        this.myDescription = description;
        return this;
    }

    public FileChooserDescriptorBuilder hideSystemRoots() {
        this.myShowFileSystemRoots = false;
        return this;
    }

    public FileChooserDescriptorBuilder showIgnored() {
        this.myHideIgnored = false;
        return this;
    }

    public FileChooserDescriptorBuilder withTreeRootVisible(boolean isTreeRootVisible) {
        this.myTreeRootVisible = isTreeRootVisible;
        return this;
    }

    public FileChooserDescriptorBuilder withRoots(List<VirtualFile> roots) {
        this.myRoots = roots;
        return this;
    }

    public FileChooserDescriptor build() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(this.myChooseFiles, this.myChooseFolders, this.myChooseJars, this.myChooseJarsAsFiles, this.myChooseJarContents, this.myChooseMultiple);
        if (this.myTitle != null) {
            descriptor.setTitle(this.myTitle);
        }
        if (this.myDescription != null) {
            descriptor.setDescription(this.myDescription);
        }
        if (this.myShowFileSystemRoots != null) {
            descriptor.setShowFileSystemRoots(this.myShowFileSystemRoots);
        }
        if (this.myHideIgnored != null) {
            descriptor.setHideIgnored(this.myHideIgnored);
        }
        if (this.myTreeRootVisible != null) {
            descriptor.setIsTreeRootVisible(this.myTreeRootVisible);
        }
        if (this.myRoots != null) {
            descriptor.setRoots(this.myRoots);
        }
        return descriptor;
    }
}

