/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.util.SystemProperties;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemExecutionSettings
implements Serializable {
    private static final String REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY = "external.system.remote.process.idle.ttl.ms";
    private static final int DEFAULT_REMOTE_PROCESS_TTL_MS = 60000;
    private static final long serialVersionUID = 1L;
    @NotNull
    private final AtomicLong myRemoteProcessIdleTtlInMs = new AtomicLong();
    @NotNull
    private final AtomicBoolean myVerboseProcessing = new AtomicBoolean();
    @NotNull
    private final AtomicReference<ExternalSystemTaskNotificationListener> myNotificationListener = new AtomicReference();

    public ExternalSystemExecutionSettings() {
        int ttl = SystemProperties.getIntProperty((String)REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY, (int)60000);
        this.setRemoteProcessIdleTtlInMs(ttl);
    }

    public long getRemoteProcessIdleTtlInMs() {
        return this.myRemoteProcessIdleTtlInMs.get();
    }

    public void setRemoteProcessIdleTtlInMs(long remoteProcessIdleTtlInMs) {
        this.myRemoteProcessIdleTtlInMs.set(remoteProcessIdleTtlInMs);
    }

    public boolean isVerboseProcessing() {
        return this.myVerboseProcessing.get();
    }

    public void setVerboseProcessing(boolean verboseProcessing) {
        this.myVerboseProcessing.set(verboseProcessing);
    }

    public int hashCode() {
        int result = (int)(this.myRemoteProcessIdleTtlInMs.get() ^ this.myRemoteProcessIdleTtlInMs.get() >>> 32);
        result = 31 * result + (this.myVerboseProcessing.get() ? 1 : 0);
        ExternalSystemTaskNotificationListener listener = this.myNotificationListener.get();
        return listener == null ? result : 31 * result + listener.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemExecutionSettings that = (ExternalSystemExecutionSettings)o;
        if (this.myRemoteProcessIdleTtlInMs.get() != that.myRemoteProcessIdleTtlInMs.get()) {
            return false;
        }
        if (this.myVerboseProcessing.get() != that.myVerboseProcessing.get()) {
            return false;
        }
        ExternalSystemTaskNotificationListener notificationListener = this.myNotificationListener.get();
        ExternalSystemTaskNotificationListener thatNotificationListener = that.myNotificationListener.get();
        return (notificationListener != null || thatNotificationListener == null) && (notificationListener == null || notificationListener.equals(thatNotificationListener));
    }
}

