/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.Identifiable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import org.jetbrains.annotations.NotNull;

public class ProjectData
extends AbstractNamedData
implements ExternalConfigPathAware,
Identifiable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myLinkedExternalProjectPath;
    @NotNull
    private String myIdeProjectFileDirectoryPath;

    @Deprecated
    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        if (ideProjectFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        if (linkedExternalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        super(owner, "unnamed");
        this.myLinkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    public ProjectData(@NotNull ProjectSystemId owner, @NotNull String externalName, @NotNull String ideProjectFileDirectoryPath, @NotNull String linkedExternalProjectPath) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        if (ideProjectFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        if (linkedExternalProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/model/project/ProjectData", "<init>"));
        }
        super(owner, externalName);
        this.myLinkedExternalProjectPath = ExternalSystemApiUtil.toCanonicalPath(linkedExternalProjectPath);
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @Deprecated
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ProjectData", "setName"));
        }
        super.setExternalName(name);
        super.setInternalName(name);
    }

    @NotNull
    public String getIdeProjectFileDirectoryPath() {
        String string = this.myIdeProjectFileDirectoryPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ProjectData", "getIdeProjectFileDirectoryPath"));
        }
        return string;
    }

    public void setIdeProjectFileDirectoryPath(@NotNull String ideProjectFileDirectoryPath) {
        if (ideProjectFileDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ProjectData", "setIdeProjectFileDirectoryPath"));
        }
        this.myIdeProjectFileDirectoryPath = ExternalSystemApiUtil.toCanonicalPath(ideProjectFileDirectoryPath);
    }

    @Override
    @NotNull
    public String getLinkedExternalProjectPath() {
        String string = this.myLinkedExternalProjectPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ProjectData", "getLinkedExternalProjectPath"));
        }
        return string;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myIdeProjectFileDirectoryPath.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectData project = (ProjectData)o;
        return this.myIdeProjectFileDirectoryPath.equals(project.myIdeProjectFileDirectoryPath);
    }

    public String toString() {
        return String.format("%s project '%s'", this.getOwner().toString().toLowerCase(), this.getExternalName());
    }

    @Override
    @NotNull
    public String getId() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ProjectData", "getId"));
        }
        return "";
    }
}

