/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRootData
extends AbstractExternalEntityData {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final Map<ExternalSystemSourceType, Collection<SourceRoot>> myData;
    @NotNull
    private final String myRootPath;

    public ContentRootData(@NotNull ProjectSystemId owner, @NotNull String rootPath) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "<init>"));
        }
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "<init>"));
        }
        super(owner);
        this.myData = ContainerUtilRt.newHashMap();
        this.myRootPath = ExternalSystemApiUtil.toCanonicalPath(rootPath);
    }

    @NotNull
    public Collection<SourceRoot> getRoots(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "getRoots"));
        }
        Collection<SourceRoot> result = this.myData.get(type);
        Collection<Object> collection = result == null ? Collections.emptyList() : result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "getRoots"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getPaths(@NotNull ExternalSystemSourceType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "getPaths"));
        }
        Collection<SourceRoot> result = this.myData.get(type);
        List list = result == null ? Collections.emptyList() : ContainerUtil.map(result, (Function)new Function<SourceRoot, String>(){

            public String fun(SourceRoot root) {
                return root.getPath();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "getPaths"));
        }
        return list;
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "storePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "storePath"));
        }
        this.storePath(type, path, null);
    }

    public void storePath(@NotNull ExternalSystemSourceType type, @NotNull String path, @Nullable String packagePrefix) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "storePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "storePath"));
        }
        if (FileUtil.isAncestor((File)new File(this.getRootPath()), (File)new File(path), (boolean)false)) {
            HashSet paths = this.myData.get(type);
            if (paths == null) {
                paths = ContainerUtilRt.newHashSet();
                this.myData.put(type, paths);
            }
            paths.add(new SourceRoot(ExternalSystemApiUtil.toCanonicalPath(path), StringUtil.nullize((String)packagePrefix, (boolean)true)));
            return;
        }
        if (!ExternalSystemSourceType.EXCLUDED.equals(type)) {
            throw new IllegalArgumentException(String.format("Can't register given path of type '%s' because it's out of content root.%nContent root: '%s'%nGiven path: '%s'", type, this.getRootPath(), new File(path).getAbsolutePath()));
        }
    }

    @NotNull
    public String getRootPath() {
        String string = this.myRootPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ContentRootData", "getRootPath"));
        }
        return string;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("content root:");
        for (Map.Entry<ExternalSystemSourceType, Collection<SourceRoot>> entry : this.myData.entrySet()) {
            buffer.append(entry.getKey().toString().toLowerCase(Locale.ENGLISH)).append("=").append(entry.getValue()).append("|");
        }
        if (!this.myData.isEmpty()) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static class SourceRoot
    implements Serializable {
        @NotNull
        private final String myPath;
        @Nullable
        private final String myPackagePrefix;

        public SourceRoot(@NotNull String path, @Nullable String prefix) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot", "<init>"));
            }
            this.myPath = path;
            this.myPackagePrefix = prefix;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot", "getPath"));
            }
            return string;
        }

        @Nullable
        public String getPackagePrefix() {
            return this.myPackagePrefix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceRoot)) {
                return false;
            }
            SourceRoot root = (SourceRoot)o;
            if (this.myPackagePrefix != null ? !this.myPackagePrefix.equals(root.myPackagePrefix) : root.myPackagePrefix != null) {
                return false;
            }
            return this.myPath.equals(root.myPath);
        }

        public int hashCode() {
            int result = this.myPath.hashCode();
            result = 31 * result + (this.myPackagePrefix != null ? this.myPackagePrefix.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("source_root(");
            buffer.append(this.myPath);
            if (this.myPackagePrefix != null) {
                buffer.append(", ").append(this.myPackagePrefix);
            }
            buffer.append(")");
            return buffer.toString();
        }
    }
}

