/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataNode<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final List<DataNode<?>> myChildren;
    @NotNull
    private final Key<T> myKey;
    private transient T myData;
    private byte[] myRawData;
    @Nullable
    private final DataNode<?> myParent;

    public DataNode(@NotNull Key<T> key, @NotNull T data, @Nullable DataNode<?> parent) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "<init>"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/DataNode", "<init>"));
        }
        this.myChildren = ContainerUtilRt.newArrayList();
        this.myKey = key;
        this.myData = data;
        this.myParent = parent;
    }

    @Nullable
    public DataNode<?> getParent() {
        return this.myParent;
    }

    @NotNull
    public <T> DataNode<T> createChild(@NotNull Key<T> key, @NotNull T data) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "createChild"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/DataNode", "createChild"));
        }
        DataNode<T> result = new DataNode<T>(key, data, this);
        this.myChildren.add(result);
        DataNode<T> dataNode = result;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DataNode", "createChild"));
        }
        return dataNode;
    }

    @NotNull
    public Key<T> getKey() {
        Key<T> key = this.myKey;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DataNode", "getKey"));
        }
        return key;
    }

    @NotNull
    public T getData() {
        if (this.myData == null) {
            this.prepareData(this.getClass().getClassLoader(), Thread.currentThread().getContextClassLoader());
        }
        T t = this.myData;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DataNode", "getData"));
        }
        return t;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareData(final ClassLoader ... loaders) {
        if (loaders == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "prepareData"));
        }
        if (this.myData != null) {
            return;
        }
        ObjectInputStream oIn = null;
        try {
            oIn = new ObjectInputStream(new ByteArrayInputStream(this.myRawData)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    for (ClassLoader loader : loaders) {
                        try {
                            return Class.forName(name, false, loader);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    return super.resolveClass(desc);
                }

                @Override
                protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
                    for (ClassLoader loader : loaders) {
                        try {
                            return this.doResolveProxyClass(interfaces, loader);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    return super.resolveProxyClass(interfaces);
                }

                private Class<?> doResolveProxyClass(@NotNull String[] interfaces, @NotNull ClassLoader loader) throws ClassNotFoundException {
                    if (interfaces == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode$1", "doResolveProxyClass"));
                    }
                    if (loader == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/model/DataNode$1", "doResolveProxyClass"));
                    }
                    ClassLoader nonPublicLoader = null;
                    boolean hasNonPublicInterface = false;
                    Class[] classObjs = new Class[interfaces.length];
                    for (int i = 0; i < interfaces.length; ++i) {
                        Class<?> cl = Class.forName(interfaces[i], false, loader);
                        if ((cl.getModifiers() & 1) == 0) {
                            if (hasNonPublicInterface) {
                                if (nonPublicLoader != cl.getClassLoader()) {
                                    throw new IllegalAccessError("conflicting non-public interface class loaders");
                                }
                            } else {
                                nonPublicLoader = cl.getClassLoader();
                                hasNonPublicInterface = true;
                            }
                        }
                        classObjs[i] = cl;
                    }
                    try {
                        return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : loader, classObjs);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ClassNotFoundException(null, e);
                    }
                }
            };
            this.myData = oIn.readObject();
            this.myRawData = null;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalStateException(String.format("Can't deserialize target data of key '%s'. Given class loaders: %s", this.myKey, Arrays.toString(loaders)), e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(oIn);
                throw throwable;
            }
        }
        StreamUtil.closeStream((Closeable)oIn);
    }

    @Nullable
    public <T> T getData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "getData"));
        }
        if (this.myKey.equals(key)) {
            return this.myData;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p.myData;
            }
            p = p.myParent;
        }
        return null;
    }

    @Nullable
    public <T> DataNode<T> getDataNode(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "getDataNode"));
        }
        if (this.myKey.equals(key)) {
            return this;
        }
        DataNode<?> p = this.myParent;
        while (p != null) {
            if (p.myKey.equals(key)) {
                return p;
            }
            p = p.myParent;
        }
        return null;
    }

    public void addChild(@NotNull DataNode<?> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/model/DataNode", "addChild"));
        }
        this.myChildren.add(child);
    }

    @NotNull
    public Collection<DataNode<?>> getChildren() {
        List<DataNode<?>> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DataNode", "getChildren"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        try {
            oOut.writeObject(this.myData);
        }
        finally {
            oOut.close();
        }
        this.myRawData = bOut.toByteArray();
        out.defaultWriteObject();
    }

    public int hashCode() {
        int result = ((Object)this.myChildren).hashCode();
        result = 31 * result + this.myKey.hashCode();
        result = 31 * result + this.getData().hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataNode node = (DataNode)o;
        if (!((Object)this.myChildren).equals(node.myChildren)) {
            return false;
        }
        if (!this.getData().equals(node.getData())) {
            return false;
        }
        return this.myKey.equals(node.myKey);
    }

    public String toString() {
        return String.format("%s: %s", this.myKey, this.getData());
    }
}

