/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class MockDocumentEvent
extends DocumentEvent {
    private final int myOffset;
    private final long myTimestamp;

    public MockDocumentEvent(@NotNull Document document, int offset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/event/MockDocumentEvent", "<init>"));
        }
        super(document);
        this.myOffset = offset;
        this.myTimestamp = document.getModificationStamp();
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = (Document)this.getSource();
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/MockDocumentEvent", "getDocument"));
        }
        return document;
    }

    @Override
    public int getOffset() {
        return this.myOffset;
    }

    @Override
    public int getOldLength() {
        return 0;
    }

    @Override
    public int getNewLength() {
        return 0;
    }

    @Override
    @NotNull
    public CharSequence getOldFragment() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/MockDocumentEvent", "getOldFragment"));
        }
        return "";
    }

    @Override
    @NotNull
    public CharSequence getNewFragment() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/event/MockDocumentEvent", "getNewFragment"));
        }
        return "";
    }

    @Override
    public long getOldTimeStamp() {
        return this.myTimestamp;
    }
}

