/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Document;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

public abstract class DocumentEvent
extends EventObject {
    protected DocumentEvent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/event/DocumentEvent", "<init>"));
        }
        super(document);
    }

    @NotNull
    public abstract Document getDocument();

    public abstract int getOffset();

    public abstract int getOldLength();

    public abstract int getNewLength();

    @NotNull
    public abstract CharSequence getOldFragment();

    @NotNull
    public abstract CharSequence getNewFragment();

    public abstract long getOldTimeStamp();

    public boolean isWholeTextReplaced() {
        return this.getOffset() == 0 && this.getNewLength() == this.getDocument().getTextLength();
    }
}

