/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ColorKey
implements Comparable<ColorKey> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.colors.ColorKey");
    private static final Color NULL_COLOR = Gray._0;
    private final String myExternalName;
    private Color myDefaultColor;
    private static final Map<String, ColorKey> ourRegistry = new HashMap<String, ColorKey>();

    private ColorKey(@NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/ColorKey", "<init>"));
        }
        this.myDefaultColor = NULL_COLOR;
        this.myExternalName = externalName;
        if (ourRegistry.containsKey(this.myExternalName)) {
            LOG.error("Key " + this.myExternalName + " already registered.");
        } else {
            ourRegistry.put(this.myExternalName, this);
        }
    }

    @NotNull
    public static ColorKey find(@NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/ColorKey", "find"));
        }
        ColorKey key = ourRegistry.get(externalName);
        ColorKey colorKey = key == null ? new ColorKey(externalName) : key;
        if (colorKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ColorKey", "find"));
        }
        return colorKey;
    }

    public String toString() {
        return this.myExternalName;
    }

    @NotNull
    public String getExternalName() {
        String string = this.myExternalName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ColorKey", "getExternalName"));
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull ColorKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/ColorKey", "compareTo"));
        }
        return this.myExternalName.compareTo(key.myExternalName);
    }

    public Color getDefaultColor() {
        if (this.myDefaultColor == NULL_COLOR) {
            this.myDefaultColor = null;
        }
        return this.myDefaultColor;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/ColorKey", "createColorKey"));
        }
        ColorKey colorKey = ColorKey.find(externalName);
        if (colorKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ColorKey", "createColorKey"));
        }
        return colorKey;
    }

    @NotNull
    public static ColorKey createColorKey(@NonNls @NotNull String externalName, Color defaultColor) {
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/colors/ColorKey", "createColorKey"));
        }
        ColorKey key = ColorKey.createColorKey(externalName);
        if (key.getDefaultColor() == null) {
            key.myDefaultColor = defaultColor;
        }
        ColorKey colorKey = key;
        if (colorKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/ColorKey", "createColorKey"));
        }
        return colorKey;
    }
}

