/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContent
extends DiffContent {
    @NotNull
    private final VirtualFile myFile;
    private Document myDocument;
    private final Project myProject;
    @Nullable
    private final FileType myType;

    public FileContent(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/FileContent", "<init>"));
        }
        this.myProject = project;
        this.myFile = file;
        this.myType = FileContent.detectType(file);
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null && DiffContentUtil.isTextFile(this.myFile)) {
            this.myDocument = FileDocumentManager.getInstance().getDocument(this.myFile);
        }
        return this.myDocument;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return new OpenFileDescriptor(this.myProject, this.myFile, offset);
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/FileContent", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        FileType type = this.myFile.getFileType();
        return FileContent.isUnknown(type) ? this.myType : type;
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        return this.myFile.contentsToByteArray();
    }

    @Override
    public boolean isBinary() {
        if (this.myFile.isDirectory()) {
            return false;
        }
        if (this.myType != null && !this.myType.isBinary()) {
            return false;
        }
        return this.myFile.getFileType().isBinary();
    }

    public static FileContent createFromTempFile(Project project, String name, String ext, @NotNull byte[] content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/diff/FileContent", "createFromTempFile"));
        }
        File tempFile = FileUtil.createTempFile((String)name, (String)("." + ext));
        if (content.length != 0) {
            FileUtil.writeToFile((File)tempFile, (byte[])content);
        }
        tempFile.deleteOnExit();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile file = lfs.findFileByIoFile(tempFile);
        if (file == null) {
            file = lfs.refreshAndFindFileByIoFile(tempFile);
        }
        if (file != null) {
            return new FileContent(project, file);
        }
        throw new IOException("Can not create temp file for revision content");
    }

    @Nullable
    private static FileType detectType(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/FileContent", "detectType"));
        }
        FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
        if (FileContent.isUnknown(type)) {
            type = FileTypeManager.getInstance().detectFileTypeFromContent(file);
        }
        return FileContent.isUnknown(type) ? null : type;
    }

    private static boolean isUnknown(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/FileContent", "isUnknown"));
        }
        return type.equals(UnknownFileType.INSTANCE);
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString((String)FileDocumentManager.getInstance().getLineSeparator(this.myFile, this.myProject));
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/FileContent", "getLineSeparator"));
        }
        return lineSeparator;
    }
}

