/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentContent
extends DiffContent {
    private final Document myDocument;
    private final VirtualFile myFile;
    private final FileType myOverriddenType;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;

    public DocumentContent(Project project, Document document) {
        this(project, document, null);
    }

    public DocumentContent(Project project, @NotNull Document document, FileType type) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/DocumentContent", "<init>"));
        }
        this.myProject = project;
        this.myDocument = document;
        this.myDocumentManager = FileDocumentManager.getInstance();
        this.myFile = this.myDocumentManager.getFile(document);
        this.myOverriddenType = type;
    }

    public DocumentContent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/DocumentContent", "<init>"));
        }
        this(null, document, null);
    }

    public DocumentContent(@NotNull Document document, @NotNull FileType type) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/DocumentContent", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/diff/DocumentContent", "<init>"));
        }
        this(null, document, type);
    }

    @Override
    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/DocumentContent", "getDocument"));
        }
        return document;
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        VirtualFile file = this.getFile();
        if (file == null) {
            return null;
        }
        if (this.myProject == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, file, offset);
    }

    @Override
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myOverriddenType == null ? DiffContentUtil.getContentType(this.getFile()) : this.myOverriddenType;
    }

    @Override
    public byte[] getBytes() {
        return this.myDocument.getText().getBytes();
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString((String)this.myDocumentManager.getLineSeparator(this.myFile, this.myProject));
        if (lineSeparator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/DocumentContent", "getLineSeparator"));
        }
        return lineSeparator;
    }
}

