/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diff.ApplicationStarterBase;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DirDiffManager;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;

public class DiffApplication
extends ApplicationStarterBase {
    public DiffApplication() {
        super("diff", 2);
    }

    @Override
    public String getUsageMessage() {
        String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
        return DiffBundle.message("diff.application.usage.parameters.and.description", scriptName);
    }

    @Override
    public void processCommand(String[] args) throws ApplicationStarterBase.OperationFailedException {
        String path1 = args[1];
        String path2 = args[2];
        VirtualFile file1 = DiffApplication.findFile(path1);
        VirtualFile file2 = DiffApplication.findFile(path2);
        boolean areDirs = DiffApplication.areDirs(file1, file2);
        boolean areJars = DiffApplication.areJars(file1, file2);
        if (areDirs || areJars) {
            DirDiffManager diffManager = DirDiffManager.getInstance(ProjectManager.getInstance().getDefaultProject());
            DiffElement d1 = diffManager.createDiffElement(file1);
            DiffElement d2 = diffManager.createDiffElement(file2);
            if (d1 == null) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message("cannot.create.diff.error", path1));
            }
            if (d2 == null) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message("cannot.create.diff.error", path1));
            }
            if (!diffManager.canShow(d1, d2)) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message("cannot.compare.error", path1, path2));
            }
            DirDiffSettings settings = new DirDiffSettings();
            settings.showInFrame = false;
            diffManager.showDiff(d1, d2, settings, null);
        } else {
            file1.refresh(false, false);
            file2.refresh(false, false);
            if (file1.getFileType() == UnknownFileType.INSTANCE) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message("unknown.file.type.error", path1));
            }
            if (file2.getFileType() == UnknownFileType.INSTANCE) {
                throw new ApplicationStarterBase.OperationFailedException(DiffBundle.message("unknown.file.type.error", path2));
            }
            SimpleDiffRequest request = SimpleDiffRequest.compareFiles(file1, file2, ProjectManager.getInstance().getDefaultProject());
            request.addHint(DiffTool.HINT_SHOW_MODAL_DIALOG);
            DiffManager.getInstance().getIdeaDiffTool().show(request);
        }
    }
}

