/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionValidator {
    public static final ExtensionPointName<InspectionValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.compiler.inspectionValidator");
    private final String myDescription;
    private final String myProgressIndicatorText;
    private final Class<? extends LocalInspectionTool>[] myInspectionToolClasses;

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends LocalInspectionTool> ... inspectionToolClasses) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = inspectionToolClasses;
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, InspectionToolProvider provider) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        this(description, progressIndicatorText, provider.getInspectionClasses());
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends InspectionToolProvider> providerClass) throws IllegalAccessException, InstantiationException {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/compiler/util/InspectionValidator", "<init>"));
        }
        this(description, progressIndicatorText, providerClass.newInstance());
    }

    public abstract boolean isAvailableOnScope(@NotNull CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidator", "getDependencies"));
        }
        return list;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        if (this.myInspectionToolClasses == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidator", "getInspectionToolClasses"));
        }
        return this.myInspectionToolClasses;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/compiler/util/InspectionValidator", "getCategoryByHighlightDisplayLevel"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/compiler/util/InspectionValidator", "getCategoryByHighlightDisplayLevel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/compiler/util/InspectionValidator", "getCategoryByHighlightDisplayLevel"));
        }
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile file) {
        Map<ProblemDescriptor, HighlightDisplayLevel> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/compiler/util/InspectionValidator", "checkAdditionally"));
        }
        return map;
    }
}

