/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.WriteCommandAction");
    private final String myName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        this(project, "Undefined", files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable @NonNls String commandName, PsiFile ... files) {
        this(project, commandName, (String)null, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String name, @Nullable String groupID, PsiFile ... files) {
        this.myName = name;
        this.myGroupID = groupID;
        this.myProject = project;
        this.myPsiFiles = files == null || files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @NotNull
    public RunResult<T> execute() {
        if (!ApplicationManager.getApplication().isDispatchThread() && ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
        }
        final RunResult result = new RunResult(this);
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WriteCommandAction.this.performWriteCommandAction(result);
                }
            };
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                runnable.run();
            } else if (application.isReadAccessAllowed()) {
                LOG.error("Calling write command from read-action leads to deadlock.");
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction", "execute"));
        }
        return runResult;
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<PsiFile> psiFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(psiFiles);
    }

    private void performWriteCommandAction(RunResult<T> result) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        final RunResult[] results = new RunResult[]{result};
        CommandProcessor.getInstance().executeCommand(this.getProject(), new Runnable(){

            @Override
            public void run() {
                WriteCommandAction.this.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        results[0].run();
                        results[0] = null;
                    }
                });
            }
        }, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return false;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    protected <T> RunResult<T> executeCommand(RunResult<T> result) {
        final RunResult[] results = new RunResult[]{result};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                if (WriteCommandAction.this.isGlobalUndoAction()) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(WriteCommandAction.this.myProject);
                }
                results[0].run();
                results[0] = null;
            }
        }, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy());
        return result;
    }

    public static void runWriteCommandAction(Project project, final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        new Simple(project, new PsiFile[0]){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }

    public static <T> T runWriteCommandAction(Project project, final @NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        return new WriteCommandAction<T>(project, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/WriteCommandAction$5", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute().getResultObject();
    }

    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result) throws Throwable {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
            }
            this.run();
        }

        protected abstract void run() throws Throwable;
    }
}

