/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public abstract class ModalityState {
    @NotNull
    public static final ModalityState NON_MODAL;

    @NotNull
    public static ModalityState current() {
        ModalityState modalityState = ApplicationManager.getApplication().getCurrentModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ModalityState", "current"));
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState any() {
        ModalityState modalityState = ApplicationManager.getApplication().getAnyModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ModalityState", "any"));
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState stateForComponent(Component component) {
        ModalityState modalityState = ApplicationManager.getApplication().getModalityStateForComponent(component);
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ModalityState", "stateForComponent"));
        }
        return modalityState;
    }

    @NotNull
    public static ModalityState defaultModalityState() {
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ModalityState", "defaultModalityState"));
        }
        return modalityState;
    }

    public abstract boolean dominates(@NotNull ModalityState var1);

    public abstract String toString();

    static {
        try {
            Class<?> ex = Class.forName("com.intellij.openapi.application.impl.ModalityStateEx");
            NON_MODAL = (ModalityState)ex.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }
}

