/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ApplicationNamesInfo {
    @NonNls
    private static final String COMPONENT_NAME = "ApplicationInfo";
    @NonNls
    private static final String ELEMENT_NAMES = "names";
    @NonNls
    private static final String ATTRIBUTE_PRODUCT = "product";
    @NonNls
    private static final String ATTRIBUTE_FULL_NAME = "fullname";
    @NonNls
    private static final String ATTRIBUTE_SCRIPT = "script";
    private String myProductName;
    private String myFullProductName;
    private String myLowercaseProductName;
    private String myScriptName;

    public static ApplicationNamesInfo getInstance() {
        return ApplicationNamesInfoHolder.ourInstance;
    }

    private ApplicationNamesInfo() {
        try {
            Document doc = JDOMUtil.loadDocument((InputStream)ApplicationNamesInfo.class.getResourceAsStream("/idea/" + ApplicationNamesInfo.getComponentName() + ".xml"));
            this.readInfo(doc.getRootElement());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readInfo(Element rootElement) {
        Element names = rootElement.getChild(ELEMENT_NAMES);
        this.myProductName = names.getAttributeValue(ATTRIBUTE_PRODUCT);
        this.myFullProductName = names.getAttributeValue(ATTRIBUTE_FULL_NAME);
        this.myLowercaseProductName = StringUtil.capitalize((String)this.myProductName.toLowerCase());
        this.myScriptName = names.getAttributeValue(ATTRIBUTE_SCRIPT);
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getLowercaseProductName() {
        return this.myLowercaseProductName;
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        if (prefix != null) {
            return prefix + COMPONENT_NAME;
        }
        return COMPONENT_NAME;
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();

        private ApplicationNamesInfoHolder() {
        }
    }
}

