/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmptyAction
extends AnAction {
    private boolean myEnabled;

    public EmptyAction() {
    }

    public EmptyAction(boolean enabled) {
        this.myEnabled = enabled;
    }

    public EmptyAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public static AnAction createEmptyAction(@Nullable String name, @Nullable Icon icon, boolean alwaysEnabled) {
        EmptyAction emptyAction = new EmptyAction(name, null, icon);
        emptyAction.myEnabled = alwaysEnabled;
        return emptyAction;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.myEnabled);
    }

    public static void setupAction(@NotNull AnAction action, @NotNull String id, @Nullable JComponent component) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/actionSystem/EmptyAction", "setupAction"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/actionSystem/EmptyAction", "setupAction"));
        }
        AnAction emptyAction = ActionManager.getInstance().getAction(id);
        Presentation copyFrom = emptyAction.getTemplatePresentation();
        Presentation copyTo = action.getTemplatePresentation();
        if (copyTo.getIcon() == null) {
            copyTo.setIcon(copyFrom.getIcon());
        }
        copyTo.setText(copyFrom.getText());
        copyTo.setDescription(copyFrom.getDescription());
        action.registerCustomShortcutSet(emptyAction.getShortcutSet(), component);
    }

    public static void registerActionShortcuts(JComponent component, JComponent fromComponent) {
        for (AnAction anAction : ActionUtil.getActions(fromComponent)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), component);
        }
    }

    public static AnAction wrap(final AnAction action) {
        return action instanceof ActionGroup ? new ActionGroup(){
            {
                this.setPopup(((ActionGroup)action).isPopup());
                this.copyFrom(action);
                this.setShortcutSet(new CustomShortcutSet());
            }

            @Override
            public void update(AnActionEvent e) {
                action.update(e);
            }

            @Override
            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = ((ActionGroup)action).getChildren(e);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/EmptyAction$1", "getChildren"));
                }
                return anActionArray;
            }
        } : new AnAction(){
            {
                this.copyFrom(action);
                this.setShortcutSet(new CustomShortcutSet());
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                action.actionPerformed(e);
            }

            @Override
            public void update(AnActionEvent e) {
                action.update(e);
            }
        };
    }
}

