/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private CustomFoldingProvider myDefaultProvider;
    private static final int MAX_LOOKUP_DEPTH = 10;

    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        if (CustomFoldingProvider.getAllProviders().length > 0) {
            this.myDefaultProvider = null;
            this.addCustomFoldingRegionsRecursively(null, root.getNode(), descriptors, 0);
        }
        this.buildLanguageFoldRegions(descriptors, root, document, quick);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        FoldingDescriptor[] foldingDescriptorArray = this.buildFoldRegions(node.getPsi(), document, false);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    protected abstract void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> var1, @NotNull PsiElement var2, @NotNull Document var3, boolean var4);

    private void addCustomFoldingRegionsRecursively(@Nullable FoldingStack foldingStack, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, int currDepth) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/folding/CustomFoldingBuilder", "addCustomFoldingRegionsRecursively"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/lang/folding/CustomFoldingBuilder", "addCustomFoldingRegionsRecursively"));
        }
        FoldingStack localFoldingStack = this.isCustomFoldingRoot(node) || foldingStack == null ? new FoldingStack(node) : foldingStack;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.isCustomRegionStart(child)) {
                localFoldingStack.push(child);
                continue;
            }
            if (this.isCustomRegionEnd(child)) {
                if (localFoldingStack.isEmpty()) continue;
                ASTNode startNode = (ASTNode)localFoldingStack.pop();
                int startOffset = startNode.getTextRange().getStartOffset();
                TextRange range = new TextRange(startOffset, child.getTextRange().getEndOffset());
                descriptors.add(new FoldingDescriptor(startNode, range));
                continue;
            }
            if (currDepth >= 10) continue;
            this.addCustomFoldingRegionsRecursively(localFoldingStack, child, descriptors, currDepth + 1);
        }
    }

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String elementText;
        CustomFoldingProvider defaultProvider;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        if (this.isCustomFoldingCandidate(node) && (defaultProvider = this.getDefaultProvider(elementText = node.getText())) != null && defaultProvider.isCustomRegionStart(elementText)) {
            return defaultProvider.getPlaceholderText(elementText);
        }
        return this.getLanguagePlaceholderText(node, range);
    }

    protected abstract String getLanguagePlaceholderText(@NotNull ASTNode var1, @NotNull TextRange var2);

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    @Override
    public final boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder", "isCollapsedByDefault"));
        }
        if (this.isCustomFoldingRoot(node)) {
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (!this.isCustomRegionStart(child)) continue;
                String childText = child.getText();
                CustomFoldingProvider defaultProvider = this.getDefaultProvider(childText);
                return defaultProvider != null && defaultProvider.isCollapsedByDefault(childText);
            }
        }
        return this.isRegionCollapsedByDefault(node);
    }

    protected abstract boolean isRegionCollapsedByDefault(@NotNull ASTNode var1);

    public final boolean isCustomRegionStart(ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionStart(nodeText);
        }
        return false;
    }

    protected final boolean isCustomRegionEnd(ASTNode node) {
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionEnd(nodeText);
        }
        return false;
    }

    @Nullable
    private CustomFoldingProvider getDefaultProvider(String elementText) {
        if (this.myDefaultProvider == null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(elementText) && !provider.isCustomRegionEnd(elementText)) continue;
                this.myDefaultProvider = provider;
            }
        }
        return this.myDefaultProvider;
    }

    protected boolean isCustomFoldingCandidate(ASTNode node) {
        return node.getPsi() instanceof PsiComment;
    }

    protected boolean isCustomFoldingRoot(ASTNode node) {
        return node.getFirstChildNode() != null;
    }

    private static class FoldingStack
    extends Stack<ASTNode> {
        private final ASTNode owner;

        public FoldingStack(@NotNull ASTNode owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack", "<init>"));
            }
            super(1);
            this.owner = owner;
        }

        @NotNull
        public ASTNode getOwner() {
            ASTNode aSTNode = this.owner;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack", "getOwner"));
            }
            return aSTNode;
        }
    }
}

