/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageUtil {
    public static final Comparator<Language> LANGUAGE_COMPARATOR = new Comparator<Language>(){

        @Override
        public int compare(Language o1, Language o2) {
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    };

    private LanguageUtil() {
    }

    public static ParserDefinition.SpaceRequirements canStickTokensTogetherByLexer(ASTNode left, ASTNode right, Lexer lexer) {
        String textStr = left.getText() + right.getText();
        lexer.start(textStr, 0, textStr.length());
        if (lexer.getTokenType() != left.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenEnd() != left.getTextLength()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        lexer.advance();
        if (lexer.getTokenEnd() != textStr.length()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (lexer.getTokenType() != right.getElementType()) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public static Language[] getLanguageDialects(final Language base) {
        List list = ContainerUtil.findAll(Language.getRegisteredLanguages(), (Condition)new Condition<Language>(){

            public boolean value(Language language) {
                return language.getBaseLanguage() == base;
            }
        });
        Language[] languageArray = list.toArray(new Language[list.size()]);
        if (languageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageUtil", "getLanguageDialects"));
        }
        return languageArray;
    }

    public static boolean isInTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        Language language = psiFile.getViewProvider().getBaseLanguage();
        return language instanceof TemplateLanguage;
    }

    public static boolean isInjectableLanguage(Language language) {
        if (language == Language.ANY) {
            return false;
        }
        if (language.getID().startsWith("$")) {
            return false;
        }
        if (language instanceof InjectableLanguage) {
            return true;
        }
        if (language instanceof TemplateLanguage || language instanceof DependentLanguage) {
            return false;
        }
        return LanguageParserDefinitions.INSTANCE.forLanguage(language) != null;
    }
}

