/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableListener;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.EventDispatcher;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportConfigurable
implements Disposable {
    private final EventDispatcher<FrameworkSupportConfigurableListener> myDispatcher = EventDispatcher.create(FrameworkSupportConfigurableListener.class);

    @Nullable
    public abstract JComponent getComponent();

    public abstract void addSupport(@NotNull Module var1, @NotNull ModifiableRootModel var2, @Nullable Library var3);

    public FrameworkVersion getSelectedVersion() {
        return null;
    }

    public List<? extends FrameworkVersion> getVersions() {
        return Collections.emptyList();
    }

    public void onFrameworkSelectionChanged(boolean selected) {
    }

    @Nullable
    public FrameworkLibraryVersionFilter getVersionFilter() {
        return FrameworkLibraryVersionFilter.ALL;
    }

    public boolean isVisible() {
        return true;
    }

    public void addListener(@NotNull FrameworkSupportConfigurableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurable", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull FrameworkSupportConfigurableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurable", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    protected void fireFrameworkVersionChanged() {
        ((FrameworkSupportConfigurableListener)this.myDispatcher.getMulticaster()).frameworkVersionChanged();
    }

    public void dispose() {
    }
}

