/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.annotations.NotNull;

public class DelegatingProgressIndicator
implements ProgressIndicator {
    private final ProgressIndicator myIndicator;

    public DelegatingProgressIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/util/DelegatingProgressIndicator", "<init>"));
        }
        this.myIndicator = indicator;
    }

    public DelegatingProgressIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        this.myIndicator = indicator == null ? new EmptyProgressIndicator() : indicator;
    }

    @Override
    public void start() {
        this.myIndicator.start();
    }

    @Override
    public void stop() {
        this.myIndicator.stop();
    }

    @Override
    public boolean isRunning() {
        return this.myIndicator.isRunning();
    }

    @Override
    public void cancel() {
        this.myIndicator.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.myIndicator.isCanceled();
    }

    @Override
    public void setText(String text) {
        this.myIndicator.setText(text);
    }

    @Override
    public String getText() {
        return this.myIndicator.getText();
    }

    @Override
    public void setText2(String text) {
        this.myIndicator.setText2(text);
    }

    @Override
    public String getText2() {
        return this.myIndicator.getText2();
    }

    @Override
    public double getFraction() {
        return this.myIndicator.getFraction();
    }

    @Override
    public void setFraction(double fraction) {
        this.myIndicator.setFraction(fraction);
    }

    @Override
    public void pushState() {
        this.myIndicator.pushState();
    }

    @Override
    public void popState() {
        this.myIndicator.popState();
    }

    @Override
    public void startNonCancelableSection() {
        this.myIndicator.startNonCancelableSection();
    }

    @Override
    public void finishNonCancelableSection() {
        this.myIndicator.finishNonCancelableSection();
    }

    @Override
    public boolean isModal() {
        return this.myIndicator.isModal();
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myIndicator.getModalityState();
        if (modalityState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/DelegatingProgressIndicator", "getModalityState"));
        }
        return modalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
        this.myIndicator.setModalityProgress(modalityProgress);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myIndicator.isIndeterminate();
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.myIndicator.setIndeterminate(indeterminate);
    }

    @Override
    public void checkCanceled() throws ProcessCanceledException {
        this.myIndicator.checkCanceled();
    }

    protected final ProgressIndicator getDelegate() {
        return this.myIndicator;
    }

    @Override
    public boolean isPopupWasShown() {
        return this.myIndicator.isPopupWasShown();
    }

    @Override
    public boolean isShowing() {
        return this.myIndicator.isShowing();
    }
}

