/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebBrowserUrlProvider {
    public static final ExtensionPointName<WebBrowserUrlProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.webBrowserUrlProvider");
    private final boolean myDeprecatedMethodOverridden;

    protected WebBrowserUrlProvider() {
        boolean deprecatedMethodOverridden;
        try {
            deprecatedMethodOverridden = this.getClass().getMethod("canHandleElement", PsiElement.class, PsiFile.class, Ref.class).getDeclaringClass() != WebBrowserUrlProvider.class || this.getClass().getMethod("canHandle", PsiElement.class, PsiFile.class, Ref.class).getDeclaringClass() != WebBrowserUrlProvider.class;
        }
        catch (Throwable ignored) {
            deprecatedMethodOverridden = false;
        }
        this.myDeprecatedMethodOverridden = deprecatedMethodOverridden;
    }

    @Deprecated
    public boolean canHandleElement(@NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull Ref<Set<Url>> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandleElement"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandleElement"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandleElement"));
        }
        Ref ref = Ref.create();
        boolean canHandle = this.canHandle(element, psiFile, (Ref<Collection<Url>>)ref);
        if (!ref.isNull()) {
            result.set((Object)ContainerUtil.newHashSet((Iterable)((Iterable)ref.get())));
        }
        return canHandle;
    }

    @Deprecated
    public boolean canHandle(@NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull Ref<Collection<Url>> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandle"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandle"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandle"));
        }
        return false;
    }

    public boolean canHandleElement(@NotNull OpenInBrowserRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "canHandleElement"));
        }
        if (this.myDeprecatedMethodOverridden) {
            Ref resultRef = Ref.create();
            if (this.canHandleElement(request.getElement(), request.getFile(), (Ref<Set<Url>>)resultRef)) {
                request.setResult((Collection)resultRef.get());
                return true;
            }
        }
        try {
            Collection<Url> urls = this.getUrls(request);
            if (!urls.isEmpty()) {
                request.setResult(urls);
                return true;
            }
        }
        catch (BrowserException browserException) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    protected Url getUrl(@NotNull OpenInBrowserRequest request, @NotNull VirtualFile virtualFile) throws BrowserException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        return this.myDeprecatedMethodOverridden ? this.getUrl(request.getElement(), request.getFile(), virtualFile) : null;
    }

    @Deprecated
    @Nullable
    public Url getUrl(@NotNull PsiElement element, @NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile) throws BrowserException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrl"));
        }
        return null;
    }

    @NotNull
    public Collection<Url> getUrls(@NotNull OpenInBrowserRequest request) throws BrowserException {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrls"));
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.getUrl(request, request.getVirtualFile()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getUrls"));
        }
        return list;
    }

    @Deprecated
    @Nullable
    public String getOpenInBrowserActionText(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getOpenInBrowserActionText"));
        }
        return null;
    }

    @Nullable
    public String getOpenInBrowserActionDescription(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/browsers/WebBrowserUrlProvider", "getOpenInBrowserActionDescription"));
        }
        return null;
    }

    public static class BrowserException
    extends Exception {
        public BrowserException(String message) {
            super(message);
        }
    }
}

