/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TreeExpander;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class DefaultTreeExpander
implements TreeExpander {
    private final JTree myTree;

    public DefaultTreeExpander(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ide/DefaultTreeExpander", "<init>"));
        }
        this.myTree = tree;
    }

    @Override
    public void expandAll() {
        TreeUtil.expandAll(this.myTree);
        this.showSelectionCentered();
    }

    @Override
    public boolean canExpand() {
        return this.myTree.isShowing();
    }

    @Override
    public void collapseAll() {
        TreeUtil.collapseAll(this.myTree, 1);
        this.showSelectionCentered();
    }

    private void showSelectionCentered() {
        int[] rowz = this.myTree.getSelectionRows();
        if (rowz != null && rowz.length > 0) {
            TreeUtil.showRowCentered(this.myTree, rowz[0], false);
        }
    }

    @Override
    public boolean canCollapse() {
        return this.myTree.isShowing();
    }
}

