/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkDetector {
    public static final ExtensionPointName<FrameworkDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.framework.detector");
    private final String myDetectorId;
    private final int myDetectorVersion;

    protected FrameworkDetector(String detectorId) {
        this(detectorId, 0);
    }

    protected FrameworkDetector(@NotNull String detectorId, int detectorVersion) {
        if (detectorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/FrameworkDetector", "<init>"));
        }
        this.myDetectorId = detectorId;
        this.myDetectorVersion = detectorVersion;
    }

    @NotNull
    public abstract FileType getFileType();

    @NotNull
    public abstract ElementPattern<FileContent> createSuitableFilePattern();

    public abstract List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> var1, @NotNull FrameworkDetectionContext var2);

    public abstract FrameworkType getFrameworkType();

    @Nullable
    public FrameworkType getUnderlyingFrameworkType() {
        return null;
    }

    @NotNull
    public final String getDetectorId() {
        String string = this.myDetectorId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FrameworkDetector", "getDetectorId"));
        }
        return string;
    }

    public final int getDetectorVersion() {
        return this.myDetectorVersion;
    }
}

