/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EmptyIcon;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetBasedFrameworkDetector<F extends Facet, C extends FacetConfiguration>
extends FrameworkDetector {
    public FacetBasedFrameworkDetector(String detectorId) {
        super(detectorId);
    }

    public abstract FacetType<F, C> getFacetType();

    @NotNull
    public List<Pair<C, Collection<VirtualFile>>> createConfigurations(@NotNull Collection<VirtualFile> files, @NotNull Collection<C> existentFacetConfigurations) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "createConfigurations"));
        }
        if (existentFacetConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "createConfigurations"));
        }
        C configuration = this.createConfiguration(files);
        if (configuration != null) {
            List<Pair<C, Collection<VirtualFile>>> list = Collections.singletonList(Pair.create(configuration, files));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "createConfigurations"));
            }
            return list;
        }
        List<Pair<C, Collection<VirtualFile>>> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "createConfigurations"));
        }
        return list;
    }

    @Nullable
    protected C createConfiguration(Collection<VirtualFile> files) {
        return this.getFacetType().createDefaultConfiguration();
    }

    public void setupFacet(@NotNull F facet, ModifiableRootModel model) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "setupFacet"));
        }
    }

    @Override
    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "detect"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/framework/detection/FacetBasedFrameworkDetector", "detect"));
        }
        return context.createDetectedFacetDescriptions(this, newFiles);
    }

    @Override
    public FrameworkType getFrameworkType() {
        return FacetBasedFrameworkDetector.createFrameworkType(this.getFacetType());
    }

    static FrameworkType createFrameworkType(FacetType<?, ?> facetType) {
        return new FacetBasedFrameworkType(facetType);
    }

    @Override
    public FrameworkType getUnderlyingFrameworkType() {
        FacetTypeId<?> underlyingTypeId = this.getFacetType().getUnderlyingFacetType();
        return underlyingTypeId != null ? FacetBasedFrameworkDetector.createFrameworkType(FacetTypeRegistry.getInstance().findFacetType(underlyingTypeId)) : null;
    }

    public boolean isSuitableUnderlyingFacetConfiguration(FacetConfiguration underlying, C configuration, Set<VirtualFile> files) {
        return true;
    }

    private static class FacetBasedFrameworkType
    extends FrameworkType {
        private final FacetType<?, ?> myFacetType;
        private final Icon myIcon;

        public FacetBasedFrameworkType(FacetType<?, ?> facetType) {
            super(facetType.getStringId());
            this.myFacetType = facetType;
            Icon icon = this.myFacetType.getIcon();
            this.myIcon = icon != null ? icon : EmptyIcon.ICON_16;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string = this.myFacetType.getPresentableName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType", "getPresentableName"));
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/framework/detection/FacetBasedFrameworkDetector$FacetBasedFrameworkType", "getIcon"));
            }
            return icon;
        }
    }
}

