/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import gnu.trove.TObjectIntHashMap;
import org.jetbrains.annotations.NotNull;

public class DependentSpacingRule {
    public static final DependentSpacingRule DEFAULT = new DependentSpacingRule(Trigger.HAS_LINE_FEEDS).registerData(Anchor.MIN_LINE_FEEDS, 1);
    private final TObjectIntHashMap<Anchor> myData;
    @NotNull
    private final Trigger myTrigger;

    public DependentSpacingRule(@NotNull Trigger trigger) {
        if (trigger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/DependentSpacingRule", "<init>"));
        }
        this.myData = new TObjectIntHashMap();
        this.myTrigger = trigger;
    }

    @NotNull
    public Trigger getTrigger() {
        Trigger trigger = this.myTrigger;
        if (trigger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/DependentSpacingRule", "getTrigger"));
        }
        return trigger;
    }

    public DependentSpacingRule registerData(@NotNull Anchor anchor, int data) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/DependentSpacingRule", "registerData"));
        }
        this.myData.put((Object)anchor, data);
        return this;
    }

    public boolean hasData(@NotNull Anchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/DependentSpacingRule", "hasData"));
        }
        return this.myData.containsKey((Object)anchor);
    }

    public int getData(@NotNull Anchor anchor) throws IllegalArgumentException {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/formatting/DependentSpacingRule", "getData"));
        }
        if (!this.myData.containsKey((Object)anchor)) {
            throw new IllegalArgumentException(String.format("No data is registered for the dependent spacing rule %s. Registered: %s", new Object[]{anchor, this.myData}));
        }
        return this.myData.get((Object)anchor);
    }

    public static enum Trigger {
        HAS_LINE_FEEDS,
        DOES_NOT_HAVE_LINE_FEEDS;

    }

    public static enum Anchor {
        MIN_LINE_FEEDS,
        MAX_LINE_FEEDS;

    }
}

